/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.encoding;

import android.support.annotation.NonNull;
import android.util.Base64;
import com.adyen.checkout.core.exception.NoConstructorException;
import java.nio.charset.Charset;

public final class Base64Encoder {
    private static final String UTF_8 = "UTF-8";
    private static final Charset DEFAULT_CHARSET = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();

    @NonNull
    public static String encode(@NonNull String decodedData) {
        return Base64Encoder.encode(decodedData, 0);
    }

    @NonNull
    public static String encode(@NonNull String decodedData, int flags) {
        byte[] decodedBytes = decodedData.getBytes(DEFAULT_CHARSET);
        return Base64.encodeToString((byte[])decodedBytes, (int)flags);
    }

    @NonNull
    public static String decode(@NonNull String encodedData) {
        return Base64Encoder.decode(encodedData, 0);
    }

    @NonNull
    public static String decode(@NonNull String encodedData, int flags) {
        byte[] decodedBytes = Base64.decode((String)encodedData, (int)flags);
        return new String(decodedBytes, DEFAULT_CHARSET);
    }

    private Base64Encoder() {
        throw new NoConstructorException();
    }
}

