/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.paymentmethods.PaymentMethod;
import com.adyen.checkout.base.model.paymentmethods.PaymentMethodsGroup;
import com.adyen.checkout.base.model.paymentmethods.StoredPaymentMethod;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import com.adyen.checkout.core.model.ModelUtils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentMethodsApiResponse
extends ModelObject {
    @NonNull
    public static final ModelObject.Creator<PaymentMethodsApiResponse> CREATOR = new ModelObject.Creator(PaymentMethodsApiResponse.class);
    private static final String GROUPS = "groups";
    private static final String STORED_PAYMENT_METHODS = "storedPaymentMethods";
    private static final String PAYMENT_METHODS = "paymentMethods";
    @NonNull
    public static final ModelObject.Serializer<PaymentMethodsApiResponse> SERIALIZER = new ModelObject.Serializer<PaymentMethodsApiResponse>(){

        @NonNull
        public JSONObject serialize(@NonNull PaymentMethodsApiResponse modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt(PaymentMethodsApiResponse.GROUPS, (Object)ModelUtils.serializeOptList(modelObject.getGroups(), PaymentMethodsGroup.SERIALIZER));
                jsonObject.putOpt(PaymentMethodsApiResponse.STORED_PAYMENT_METHODS, (Object)ModelUtils.serializeOptList(modelObject.getStoredPaymentMethods(), StoredPaymentMethod.SERIALIZER));
                jsonObject.putOpt(PaymentMethodsApiResponse.PAYMENT_METHODS, (Object)ModelUtils.serializeOptList(modelObject.getPaymentMethods(), PaymentMethod.SERIALIZER));
            }
            catch (JSONException e) {
                throw new ModelSerializationException(PaymentMethodsApiResponse.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public PaymentMethodsApiResponse deserialize(@NonNull JSONObject jsonObject) {
            PaymentMethodsApiResponse paymentMethodsApiResponse = new PaymentMethodsApiResponse();
            paymentMethodsApiResponse.setGroups(ModelUtils.deserializeOptList((JSONArray)jsonObject.optJSONArray(PaymentMethodsApiResponse.GROUPS), PaymentMethodsGroup.SERIALIZER));
            paymentMethodsApiResponse.setStoredPaymentMethods(ModelUtils.deserializeOptList((JSONArray)jsonObject.optJSONArray(PaymentMethodsApiResponse.STORED_PAYMENT_METHODS), StoredPaymentMethod.SERIALIZER));
            paymentMethodsApiResponse.setPaymentMethods(ModelUtils.deserializeOptList((JSONArray)jsonObject.optJSONArray(PaymentMethodsApiResponse.PAYMENT_METHODS), PaymentMethod.SERIALIZER));
            return paymentMethodsApiResponse;
        }
    };
    private List<PaymentMethodsGroup> groups;
    private List<StoredPaymentMethod> storedPaymentMethods;
    private List<PaymentMethod> paymentMethods;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public List<PaymentMethodsGroup> getGroups() {
        return this.groups;
    }

    @Nullable
    public List<StoredPaymentMethod> getStoredPaymentMethods() {
        return this.storedPaymentMethods;
    }

    @Nullable
    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public void setGroups(@Nullable List<PaymentMethodsGroup> groups) {
        this.groups = groups;
    }

    public void setStoredPaymentMethods(@Nullable List<StoredPaymentMethod> storedPaymentMethods) {
        this.storedPaymentMethods = storedPaymentMethods;
    }

    public void setPaymentMethods(@Nullable List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }
}

