/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.paymentmethods;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.paymentmethods.Group;
import com.adyen.checkout.base.model.paymentmethods.InputDetail;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import com.adyen.checkout.core.model.ModelUtils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentMethod
extends ModelObject {
    @NonNull
    public static final ModelObject.Creator<PaymentMethod> CREATOR = new ModelObject.Creator(PaymentMethod.class);
    private static final String CONFIGURATION = "configuration";
    private static final String DETAILS = "details";
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String BRANDS = "brands";
    private static final String PAYMENT_METHOD_DATA = "paymentMethodData";
    private static final String SUPPORTS_RECURRING = "supportsRecurring";
    private static final String TYPE = "type";
    @NonNull
    public static final ModelObject.Serializer<PaymentMethod> SERIALIZER = new ModelObject.Serializer<PaymentMethod>(){

        @NonNull
        public JSONObject serialize(@NonNull PaymentMethod modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt(PaymentMethod.CONFIGURATION, (Object)modelObject.getConfiguration());
                jsonObject.putOpt(PaymentMethod.DETAILS, (Object)ModelUtils.serializeOptList(modelObject.getDetails(), InputDetail.SERIALIZER));
                jsonObject.putOpt(PaymentMethod.GROUP, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getGroup(), Group.SERIALIZER));
                jsonObject.putOpt(PaymentMethod.NAME, (Object)modelObject.getName());
                jsonObject.putOpt(PaymentMethod.BRANDS, (Object)JsonUtils.serializeOptStringList(modelObject.getBrands()));
                jsonObject.putOpt(PaymentMethod.PAYMENT_METHOD_DATA, (Object)modelObject.getPaymentMethodData());
                jsonObject.putOpt(PaymentMethod.SUPPORTS_RECURRING, (Object)modelObject.getSupportsRecurring());
                jsonObject.putOpt(PaymentMethod.TYPE, (Object)modelObject.getType());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(PaymentMethod.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public PaymentMethod deserialize(@NonNull JSONObject jsonObject) {
            PaymentMethod paymentMethod = new PaymentMethod();
            paymentMethod.setConfiguration(jsonObject.optString(PaymentMethod.CONFIGURATION, null));
            paymentMethod.setDetails(ModelUtils.deserializeOptList((JSONArray)jsonObject.optJSONArray(PaymentMethod.DETAILS), InputDetail.SERIALIZER));
            paymentMethod.setGroup((Group)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(PaymentMethod.GROUP), Group.SERIALIZER));
            paymentMethod.setName(jsonObject.optString(PaymentMethod.NAME, null));
            paymentMethod.setBrands(JsonUtils.parseOptStringList((JSONArray)jsonObject.optJSONArray(PaymentMethod.BRANDS)));
            paymentMethod.setPaymentMethodData(jsonObject.optString(PaymentMethod.PAYMENT_METHOD_DATA, null));
            paymentMethod.setSupportsRecurring(jsonObject.optBoolean(PaymentMethod.SUPPORTS_RECURRING, false));
            paymentMethod.setType(jsonObject.optString(PaymentMethod.TYPE, null));
            return paymentMethod;
        }
    };
    private String configuration;
    private List<InputDetail> details;
    private Group group;
    private String name;
    private List<String> brands;
    private String paymentMethodData;
    private boolean supportsRecurring;
    private String type;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public List<InputDetail> getDetails() {
        return this.details;
    }

    @Nullable
    public Group getGroup() {
        return this.group;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPaymentMethodData() {
        return this.paymentMethodData;
    }

    public boolean getSupportsRecurring() {
        return this.supportsRecurring;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setConfiguration(@Nullable String configuration) {
        this.configuration = configuration;
    }

    public void setDetails(@Nullable List<InputDetail> details) {
        this.details = details;
    }

    public void setGroup(@Nullable Group group) {
        this.group = group;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void setBrands(@Nullable List<String> brands) {
        this.brands = brands;
    }

    @Nullable
    public List<String> getBrands() {
        return this.brands;
    }

    public void setPaymentMethodData(@Nullable String paymentMethodData) {
        this.paymentMethodData = paymentMethodData;
    }

    public void setSupportsRecurring(boolean supportsRecurring) {
        this.supportsRecurring = supportsRecurring;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }
}

