/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.paymentmethods;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.paymentmethods.PaymentMethod;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StoredPaymentMethod
extends PaymentMethod {
    @NonNull
    public static final ModelObject.Creator<StoredPaymentMethod> CREATOR = new ModelObject.Creator(StoredPaymentMethod.class);
    private static final String BRAND = "brand";
    private static final String EXPIRY_MONTH = "expiryMonth";
    private static final String EXPIRY_YEAR = "expiryYear";
    private static final String HOLDER_NAME = "holderName";
    private static final String ID = "id";
    private static final String LAST_FOUR = "lastFour";
    private static final String SHOPPER_EMAIL = "shopperEmail";
    private static final String SUPPORTED_SHOPPER_INTERACTIONS = "supportedShopperInteractions";
    private static final String ECOMMERCE = "Ecommerce";
    @NonNull
    public static final ModelObject.Serializer<StoredPaymentMethod> SERIALIZER = new ModelObject.Serializer<StoredPaymentMethod>(){

        @NonNull
        public JSONObject serialize(@NonNull StoredPaymentMethod modelObject) {
            JSONObject jsonObject = PaymentMethod.SERIALIZER.serialize((ModelObject)modelObject);
            try {
                jsonObject.putOpt(StoredPaymentMethod.BRAND, (Object)modelObject.getBrand());
                jsonObject.putOpt(StoredPaymentMethod.EXPIRY_MONTH, (Object)modelObject.getExpiryMonth());
                jsonObject.putOpt(StoredPaymentMethod.EXPIRY_YEAR, (Object)modelObject.getExpiryYear());
                jsonObject.putOpt(StoredPaymentMethod.HOLDER_NAME, (Object)modelObject.getHolderName());
                jsonObject.putOpt(StoredPaymentMethod.ID, (Object)modelObject.getId());
                jsonObject.putOpt(StoredPaymentMethod.LAST_FOUR, (Object)modelObject.getLastFour());
                jsonObject.putOpt(StoredPaymentMethod.SHOPPER_EMAIL, (Object)modelObject.getShopperEmail());
                jsonObject.putOpt(StoredPaymentMethod.SUPPORTED_SHOPPER_INTERACTIONS, (Object)new JSONArray(modelObject.getSupportedShopperInteractions()));
            }
            catch (JSONException e) {
                throw new ModelSerializationException(StoredPaymentMethod.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public StoredPaymentMethod deserialize(@NonNull JSONObject jsonObject) {
            StoredPaymentMethod storedPaymentMethod = new StoredPaymentMethod();
            PaymentMethod paymentMethod = (PaymentMethod)PaymentMethod.SERIALIZER.deserialize(jsonObject);
            storedPaymentMethod.setConfiguration(paymentMethod.getConfiguration());
            storedPaymentMethod.setDetails(paymentMethod.getDetails());
            storedPaymentMethod.setGroup(paymentMethod.getGroup());
            storedPaymentMethod.setName(paymentMethod.getName());
            storedPaymentMethod.setPaymentMethodData(paymentMethod.getPaymentMethodData());
            storedPaymentMethod.setSupportsRecurring(paymentMethod.getSupportsRecurring());
            storedPaymentMethod.setType(paymentMethod.getType());
            storedPaymentMethod.setBrand(jsonObject.optString(StoredPaymentMethod.BRAND));
            storedPaymentMethod.setExpiryMonth(jsonObject.optString(StoredPaymentMethod.EXPIRY_MONTH));
            storedPaymentMethod.setExpiryYear(jsonObject.optString(StoredPaymentMethod.EXPIRY_YEAR));
            storedPaymentMethod.setHolderName(jsonObject.optString(StoredPaymentMethod.HOLDER_NAME));
            storedPaymentMethod.setId(jsonObject.optString(StoredPaymentMethod.ID));
            storedPaymentMethod.setLastFour(jsonObject.optString(StoredPaymentMethod.LAST_FOUR));
            storedPaymentMethod.setShopperEmail(jsonObject.optString(StoredPaymentMethod.SHOPPER_EMAIL));
            List supportedShopperInteractions = JsonUtils.parseOptStringList((JSONArray)jsonObject.optJSONArray(StoredPaymentMethod.SUPPORTED_SHOPPER_INTERACTIONS));
            if (supportedShopperInteractions != null) {
                storedPaymentMethod.setSupportedShopperInteractions(supportedShopperInteractions);
            }
            return storedPaymentMethod;
        }
    };
    private String brand;
    private String expiryMonth;
    private String expiryYear;
    private String holderName;
    private String id;
    private String lastFour;
    private String shopperEmail;
    private List<String> supportedShopperInteractions = Collections.emptyList();

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @NonNull
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(@Nullable String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    @NonNull
    public String getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(@Nullable String expiryYear) {
        this.expiryYear = expiryYear;
    }

    @NonNull
    public String getLastFour() {
        return this.lastFour;
    }

    public void setLastFour(@Nullable String lastFour) {
        this.lastFour = lastFour;
    }

    @NonNull
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(@NonNull String brand) {
        this.brand = brand;
    }

    @NonNull
    public List<String> getSupportedShopperInteractions() {
        return this.supportedShopperInteractions;
    }

    public void setSupportedShopperInteractions(@NonNull List<String> supportedShopperInteractions) {
        this.supportedShopperInteractions = supportedShopperInteractions;
    }

    @Nullable
    public String getHolderName() {
        return this.holderName;
    }

    public void setHolderName(@Nullable String holderName) {
        this.holderName = holderName;
    }

    @Nullable
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(@Nullable String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public boolean isEcommerce() {
        return this.supportedShopperInteractions.contains(ECOMMERCE);
    }
}

