/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public class Amount
extends ModelObject {
    @NonNull
    public static final ModelObject.Creator<Amount> CREATOR = new ModelObject.Creator(Amount.class);
    @NonNull
    public static final Amount EMPTY = new Amount();
    private static final String EMPTY_CURRENCY = "NONE";
    private static final int EMPTY_VALUE = -1;
    private static final String CURRENCY = "currency";
    private static final String VALUE = "value";
    @NonNull
    public static final ModelObject.Serializer<Amount> SERIALIZER;
    private String currency;
    private int value;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(@Nullable String currency) {
        this.currency = currency;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return EMPTY_CURRENCY.equals(this.currency) || this.value == -1;
    }

    static {
        EMPTY.setCurrency(EMPTY_CURRENCY);
        EMPTY.setValue(-1);
        SERIALIZER = new ModelObject.Serializer<Amount>(){

            @NonNull
            public JSONObject serialize(@NonNull Amount modelObject) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.putOpt(Amount.CURRENCY, (Object)modelObject.getCurrency());
                    jsonObject.putOpt(Amount.VALUE, (Object)modelObject.getValue());
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(Amount.class, e);
                }
                return jsonObject;
            }

            @NonNull
            public Amount deserialize(@NonNull JSONObject jsonObject) {
                Amount amount = new Amount();
                amount.setCurrency(jsonObject.optString(Amount.CURRENCY, null));
                amount.setValue(jsonObject.optInt(Amount.VALUE, -1));
                return amount;
            }
        };
    }
}

