/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.request;

import android.os.Parcel;
import android.support.annotation.NonNull;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public class Address
extends ModelObject {
    @NonNull
    public static final ModelObject.Creator<Address> CREATOR = new ModelObject.Creator(Address.class);
    private static final String CITY = "city";
    private static final String COUNTRY = "country";
    private static final String HOUSE_NUMBER_OR_NAME = "houseNumberOrName";
    private static final String POSTAL_CODE = "postalCode";
    private static final String STATE_OR_PROVINCE = "stateOrProvince";
    private static final String STREET = "street";
    @NonNull
    public static final ModelObject.Serializer<Address> SERIALIZER = new ModelObject.Serializer<Address>(){

        @NonNull
        public JSONObject serialize(@NonNull Address modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt(Address.CITY, (Object)modelObject.getCity());
                jsonObject.putOpt(Address.COUNTRY, (Object)modelObject.getCountry());
                jsonObject.putOpt(Address.HOUSE_NUMBER_OR_NAME, (Object)modelObject.getHouseNumberOrName());
                jsonObject.putOpt(Address.POSTAL_CODE, (Object)modelObject.getPostalCode());
                jsonObject.putOpt(Address.STATE_OR_PROVINCE, (Object)modelObject.getStateOrProvince());
                jsonObject.putOpt(Address.STREET, (Object)modelObject.getStreet());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(Address.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public Address deserialize(@NonNull JSONObject jsonObject) {
            Address address = new Address();
            address.setCity(jsonObject.optString(Address.CITY, null));
            address.setCountry(jsonObject.optString(Address.COUNTRY, null));
            address.setHouseNumberOrName(jsonObject.optString(Address.HOUSE_NUMBER_OR_NAME, null));
            address.setPostalCode(jsonObject.optString(Address.POSTAL_CODE, null));
            address.setStateOrProvince(jsonObject.optString(Address.STATE_OR_PROVINCE, null));
            address.setStreet(jsonObject.optString(Address.STREET, null));
            return address;
        }
    };
    private String city;
    private String country;
    private String houseNumberOrName;
    private String postalCode;
    private String stateOrProvince;
    private String street;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @NonNull
    public String getCity() {
        return this.city;
    }

    public void setCity(@NonNull String city) {
        this.city = city;
    }

    @NonNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(@NonNull String country) {
        this.country = country;
    }

    @NonNull
    public String getHouseNumberOrName() {
        return this.houseNumberOrName;
    }

    public void setHouseNumberOrName(@NonNull String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
    }

    @NonNull
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(@NonNull String postalCode) {
        this.postalCode = postalCode;
    }

    @NonNull
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(@NonNull String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    @NonNull
    public String getStreet() {
        return this.street;
    }

    public void setStreet(@NonNull String street) {
        this.street = street;
    }
}

