/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.request;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.request.IdealPaymentMethod;
import com.adyen.checkout.base.model.payments.request.PaymentMethodDetails;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public final class CardPaymentMethod
extends PaymentMethodDetails {
    @NonNull
    public static final ModelObject.Creator<CardPaymentMethod> CREATOR = new ModelObject.Creator(CardPaymentMethod.class);
    public static final String PAYMENT_METHOD_TYPE = "scheme";
    private static final String ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
    private static final String ENCRYPTED_EXPIRY_MONTH = "encryptedExpiryMonth";
    private static final String ENCRYPTED_EXPIRY_YEAR = "encryptedExpiryYear";
    private static final String ENCRYPTED_SECURITY_CODE = "encryptedSecurityCode";
    private static final String HOLDER_NAME = "holderName";
    private static final String STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    @NonNull
    public static final ModelObject.Serializer<CardPaymentMethod> SERIALIZER = new ModelObject.Serializer<CardPaymentMethod>(){

        @NonNull
        public JSONObject serialize(@NonNull CardPaymentMethod modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt(CardPaymentMethod.ENCRYPTED_CARD_NUMBER, (Object)modelObject.getEncryptedCardNumber());
                jsonObject.putOpt(CardPaymentMethod.ENCRYPTED_EXPIRY_MONTH, (Object)modelObject.getEncryptedExpiryMonth());
                jsonObject.putOpt(CardPaymentMethod.ENCRYPTED_EXPIRY_YEAR, (Object)modelObject.getEncryptedExpiryYear());
                jsonObject.putOpt(CardPaymentMethod.ENCRYPTED_SECURITY_CODE, (Object)modelObject.getEncryptedSecurityCode());
                jsonObject.putOpt(CardPaymentMethod.STORED_PAYMENT_METHOD_ID, (Object)modelObject.getStoredPaymentMethodId());
                jsonObject.putOpt(CardPaymentMethod.HOLDER_NAME, (Object)modelObject.getHolderName());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(IdealPaymentMethod.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public CardPaymentMethod deserialize(@NonNull JSONObject jsonObject) {
            CardPaymentMethod cardPaymentMethod = new CardPaymentMethod();
            cardPaymentMethod.setType(jsonObject.optString("type", null));
            cardPaymentMethod.setEncryptedCardNumber(jsonObject.optString(CardPaymentMethod.ENCRYPTED_CARD_NUMBER, null));
            cardPaymentMethod.setEncryptedExpiryMonth(jsonObject.optString(CardPaymentMethod.ENCRYPTED_EXPIRY_MONTH, null));
            cardPaymentMethod.setEncryptedExpiryYear(jsonObject.optString(CardPaymentMethod.ENCRYPTED_EXPIRY_YEAR, null));
            cardPaymentMethod.setStoredPaymentMethodId(jsonObject.optString(CardPaymentMethod.STORED_PAYMENT_METHOD_ID));
            cardPaymentMethod.setEncryptedSecurityCode(jsonObject.optString(CardPaymentMethod.ENCRYPTED_SECURITY_CODE, null));
            cardPaymentMethod.setHolderName(jsonObject.optString(CardPaymentMethod.HOLDER_NAME, null));
            return cardPaymentMethod;
        }
    };
    private String encryptedCardNumber;
    private String encryptedExpiryMonth;
    private String encryptedExpiryYear;
    private String encryptedSecurityCode;
    private String holderName;
    private String storedPaymentMethodId;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public String getEncryptedCardNumber() {
        return this.encryptedCardNumber;
    }

    public void setEncryptedCardNumber(@Nullable String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    @Nullable
    public String getEncryptedExpiryMonth() {
        return this.encryptedExpiryMonth;
    }

    public void setEncryptedExpiryMonth(@Nullable String encryptedExpiryMonth) {
        this.encryptedExpiryMonth = encryptedExpiryMonth;
    }

    @Nullable
    public String getEncryptedExpiryYear() {
        return this.encryptedExpiryYear;
    }

    public void setEncryptedExpiryYear(@Nullable String encryptedExpiryYear) {
        this.encryptedExpiryYear = encryptedExpiryYear;
    }

    @Nullable
    public String getEncryptedSecurityCode() {
        return this.encryptedSecurityCode;
    }

    public void setEncryptedSecurityCode(@Nullable String encryptedSecurityCode) {
        this.encryptedSecurityCode = encryptedSecurityCode;
    }

    @Nullable
    public String getHolderName() {
        return this.holderName;
    }

    public void setHolderName(@Nullable String holderName) {
        this.holderName = holderName;
    }

    @Deprecated
    @Nullable
    public String getRecurringDetailReference() {
        return this.storedPaymentMethodId;
    }

    @Deprecated
    public void setRecurringDetailReference(@Nullable String recurringDetailReference) {
        this.storedPaymentMethodId = recurringDetailReference;
    }

    public void setStoredPaymentMethodId(@Nullable String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    @Nullable
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }
}

