/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.request;

import android.os.Parcel;
import android.support.annotation.NonNull;
import com.adyen.checkout.base.model.payments.request.IssuerListPaymentMethod;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public final class EPSPaymentMethod
extends IssuerListPaymentMethod {
    @NonNull
    public static final ModelObject.Creator<EPSPaymentMethod> CREATOR = new ModelObject.Creator(EPSPaymentMethod.class);
    public static final String PAYMENT_METHOD_TYPE = "eps";
    @NonNull
    public static final ModelObject.Serializer<EPSPaymentMethod> SERIALIZER = new ModelObject.Serializer<EPSPaymentMethod>(){

        @NonNull
        public JSONObject serialize(@NonNull EPSPaymentMethod modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt("issuer", (Object)modelObject.getIssuer());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(EPSPaymentMethod.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public EPSPaymentMethod deserialize(@NonNull JSONObject jsonObject) {
            EPSPaymentMethod idealPaymentMethod = new EPSPaymentMethod();
            idealPaymentMethod.setType(jsonObject.optString("type", null));
            idealPaymentMethod.setIssuer(jsonObject.optString("issuer", null));
            return idealPaymentMethod;
        }
    };

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }
}

