/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.request;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.request.PaymentMethodDetails;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public class GooglePayPaymentMethod
extends PaymentMethodDetails {
    @NonNull
    public static final ModelObject.Creator<GooglePayPaymentMethod> CREATOR = new ModelObject.Creator(GooglePayPaymentMethod.class);
    public static final String PAYMENT_METHOD_TYPE = "paywithgoogle";
    private static final String GOOGLE_PAY_TOKEN = "googlePayToken";
    private static final String GOOGLE_PAY_CARD_NETWORK = "googlePayCardNetwork";
    @NonNull
    public static final ModelObject.Serializer<GooglePayPaymentMethod> SERIALIZER = new ModelObject.Serializer<GooglePayPaymentMethod>(){

        @NonNull
        public JSONObject serialize(@NonNull GooglePayPaymentMethod modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt(GooglePayPaymentMethod.GOOGLE_PAY_TOKEN, (Object)modelObject.getGooglePayToken());
                jsonObject.putOpt(GooglePayPaymentMethod.GOOGLE_PAY_CARD_NETWORK, (Object)modelObject.getGooglePayCardNetwork());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(GooglePayPaymentMethod.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public GooglePayPaymentMethod deserialize(@NonNull JSONObject jsonObject) {
            GooglePayPaymentMethod googlePayPaymentMethod = new GooglePayPaymentMethod();
            googlePayPaymentMethod.setType(jsonObject.optString("type", null));
            googlePayPaymentMethod.setGooglePayToken(jsonObject.optString(GooglePayPaymentMethod.GOOGLE_PAY_TOKEN, null));
            googlePayPaymentMethod.setGooglePayCardNetwork(jsonObject.optString(GooglePayPaymentMethod.GOOGLE_PAY_CARD_NETWORK, null));
            return googlePayPaymentMethod;
        }
    };
    private String googlePayToken;
    private String googlePayCardNetwork;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Deprecated
    @Nullable
    public String getToken() {
        return this.googlePayToken;
    }

    @Deprecated
    public void setToken(@Nullable String token) {
        this.googlePayToken = token;
    }

    @Nullable
    public String getGooglePayToken() {
        return this.googlePayToken;
    }

    public void setGooglePayToken(@Nullable String googlePayToken) {
        this.googlePayToken = googlePayToken;
    }

    @Nullable
    public String getGooglePayCardNetwork() {
        return this.googlePayCardNetwork;
    }

    public void setGooglePayCardNetwork(@Nullable String googlePayCardNetwork) {
        this.googlePayCardNetwork = googlePayCardNetwork;
    }
}

