/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.request;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.base.model.payments.request.Address;
import com.adyen.checkout.base.model.payments.request.PaymentMethodDetails;
import com.adyen.checkout.base.model.payments.request.ShopperName;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import com.adyen.checkout.core.model.ModelUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentComponentData<PaymentMethodDetailsT extends PaymentMethodDetails>
extends ModelObject {
    @NonNull
    public static final ModelObject.Creator<PaymentComponentData> CREATOR = new ModelObject.Creator(PaymentComponentData.class);
    private static final String PAYMENT_METHOD = "paymentMethod";
    private static final String STORE_PAYMENT_METHOD = "storePaymentMethod";
    private static final String SHOPPER_REFERENCE = "shopperReference";
    private static final String AMOUNT = "amount";
    private static final String BILLING_ADDRESS = "billingAddress";
    private static final String DELIVERY_ADDRESS = "deliveryAddress";
    private static final String SHOPPER_NAME = "shopperName";
    private static final String TELEPHONE_NUMBER = "telephoneNumber";
    private static final String SHOPPER_EMAIL = "shopperEmail";
    private static final String DATE_OF_BIRTH = "dateOfBirth";
    @NonNull
    public static final ModelObject.Serializer<PaymentComponentData> SERIALIZER = new ModelObject.Serializer<PaymentComponentData>(){

        @NonNull
        public JSONObject serialize(@NonNull PaymentComponentData modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt(PaymentComponentData.PAYMENT_METHOD, (Object)ModelUtils.serializeOpt(modelObject.getPaymentMethod(), PaymentMethodDetails.SERIALIZER));
                jsonObject.putOpt(PaymentComponentData.STORE_PAYMENT_METHOD, (Object)modelObject.isStorePaymentMethodEnable());
                jsonObject.putOpt(PaymentComponentData.SHOPPER_REFERENCE, (Object)modelObject.getShopperReference());
                jsonObject.putOpt(PaymentComponentData.AMOUNT, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getAmount(), Amount.SERIALIZER));
                jsonObject.putOpt(PaymentComponentData.BILLING_ADDRESS, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getBillingAddress(), Address.SERIALIZER));
                jsonObject.putOpt(PaymentComponentData.DELIVERY_ADDRESS, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getDeliveryAddress(), Address.SERIALIZER));
                jsonObject.putOpt(PaymentComponentData.SHOPPER_NAME, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getShopperName(), ShopperName.SERIALIZER));
                jsonObject.putOpt(PaymentComponentData.TELEPHONE_NUMBER, (Object)modelObject.getTelephoneNumber());
                jsonObject.putOpt(PaymentComponentData.SHOPPER_EMAIL, (Object)modelObject.getShopperEmail());
                jsonObject.putOpt(PaymentComponentData.DATE_OF_BIRTH, (Object)modelObject.getDateOfBirth());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(PaymentComponentData.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public PaymentComponentData deserialize(@NonNull JSONObject jsonObject) {
            PaymentComponentData<PaymentMethodDetails> paymentComponentData = new PaymentComponentData<PaymentMethodDetails>();
            paymentComponentData.setPaymentMethod((PaymentMethodDetails)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(PaymentComponentData.PAYMENT_METHOD), PaymentMethodDetails.SERIALIZER));
            paymentComponentData.setStorePaymentMethod(jsonObject.optBoolean(PaymentComponentData.STORE_PAYMENT_METHOD));
            paymentComponentData.setShopperReference(jsonObject.optString(PaymentComponentData.SHOPPER_REFERENCE));
            paymentComponentData.setAmount((Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(PaymentComponentData.AMOUNT), Amount.SERIALIZER));
            paymentComponentData.setBillingAddress((Address)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(PaymentComponentData.BILLING_ADDRESS), Address.SERIALIZER));
            paymentComponentData.setDeliveryAddress((Address)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(PaymentComponentData.DELIVERY_ADDRESS), Address.SERIALIZER));
            paymentComponentData.setShopperName((ShopperName)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(PaymentComponentData.SHOPPER_NAME), ShopperName.SERIALIZER));
            paymentComponentData.setTelephoneNumber(jsonObject.optString(PaymentComponentData.TELEPHONE_NUMBER));
            paymentComponentData.setShopperEmail(jsonObject.optString(PaymentComponentData.SHOPPER_EMAIL));
            paymentComponentData.setDateOfBirth(jsonObject.optString(PaymentComponentData.DATE_OF_BIRTH));
            return paymentComponentData;
        }
    };
    private PaymentMethodDetailsT paymentMethod;
    private boolean storePaymentMethod;
    private String shopperReference;
    private Amount amount;
    private Address billingAddress;
    private Address deliveryAddress;
    private ShopperName shopperName;
    private String telephoneNumber;
    private String shopperEmail;
    private String dateOfBirth;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public PaymentMethodDetailsT getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(@Nullable PaymentMethodDetailsT paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setStorePaymentMethod(boolean status) {
        this.storePaymentMethod = status;
    }

    public boolean isStorePaymentMethodEnable() {
        return this.storePaymentMethod;
    }

    public void setShopperReference(@Nullable String shopperReference) {
        this.shopperReference = shopperReference;
    }

    @Nullable
    public String getShopperReference() {
        return this.shopperReference;
    }

    @Nullable
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(@Nullable Amount amount) {
        this.amount = amount;
    }

    @Nullable
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(@Nullable Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    @Nullable
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(@Nullable Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    @Nullable
    public ShopperName getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(@Nullable ShopperName shopperName) {
        this.shopperName = shopperName;
    }

    @Nullable
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(@Nullable String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @Nullable
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(@Nullable String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    @Nullable
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(@Nullable String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }
}

