/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.request;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.adyen.checkout.base.model.payments.request.AfterPayPaymentMethod;
import com.adyen.checkout.base.model.payments.request.BlikPaymentMethod;
import com.adyen.checkout.base.model.payments.request.CardPaymentMethod;
import com.adyen.checkout.base.model.payments.request.DotpayPaymentMethod;
import com.adyen.checkout.base.model.payments.request.EPSPaymentMethod;
import com.adyen.checkout.base.model.payments.request.EntercashPaymentMethod;
import com.adyen.checkout.base.model.payments.request.GenericPaymentMethod;
import com.adyen.checkout.base.model.payments.request.GooglePayPaymentMethod;
import com.adyen.checkout.base.model.payments.request.IdealPaymentMethod;
import com.adyen.checkout.base.model.payments.request.MBWayPaymentMethod;
import com.adyen.checkout.base.model.payments.request.MolpayPaymentMethod;
import com.adyen.checkout.base.model.payments.request.OpenBankingPaymentMethod;
import com.adyen.checkout.base.model.payments.request.SepaPaymentMethod;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONObject;

public abstract class PaymentMethodDetails
extends ModelObject {
    public static final String TYPE = "type";
    @NonNull
    public static final ModelObject.Serializer<PaymentMethodDetails> SERIALIZER = new ModelObject.Serializer<PaymentMethodDetails>(){

        @NonNull
        public JSONObject serialize(@NonNull PaymentMethodDetails modelObject) {
            String paymentMethodType = modelObject.getType();
            if (TextUtils.isEmpty((CharSequence)paymentMethodType)) {
                throw new CheckoutException("PaymentMethod type not found");
            }
            ModelObject.Serializer<? extends PaymentMethodDetails> serializer = PaymentMethodDetails.getChildSerializer(paymentMethodType);
            return serializer.serialize((ModelObject)modelObject);
        }

        @NonNull
        public PaymentMethodDetails deserialize(@NonNull JSONObject jsonObject) {
            String actionType = jsonObject.optString(PaymentMethodDetails.TYPE, null);
            if (TextUtils.isEmpty((CharSequence)actionType)) {
                throw new CheckoutException("PaymentMethod type not found");
            }
            ModelObject.Serializer<? extends PaymentMethodDetails> serializer = PaymentMethodDetails.getChildSerializer(actionType);
            return (PaymentMethodDetails)serializer.deserialize(jsonObject);
        }
    };
    private String type;

    @NonNull
    static ModelObject.Serializer<? extends PaymentMethodDetails> getChildSerializer(@NonNull String paymentMethodType) {
        switch (paymentMethodType) {
            case "ideal": {
                return IdealPaymentMethod.SERIALIZER;
            }
            case "scheme": {
                return CardPaymentMethod.SERIALIZER;
            }
            case "molpay_ebanking_fpx_MY": 
            case "molpay_ebanking_TH": 
            case "molpay_ebanking_VN": {
                return MolpayPaymentMethod.SERIALIZER;
            }
            case "dotpay": {
                return DotpayPaymentMethod.SERIALIZER;
            }
            case "eps": {
                return EPSPaymentMethod.SERIALIZER;
            }
            case "openbanking_UK": {
                return OpenBankingPaymentMethod.SERIALIZER;
            }
            case "entercash": {
                return EntercashPaymentMethod.SERIALIZER;
            }
            case "paywithgoogle": {
                return GooglePayPaymentMethod.SERIALIZER;
            }
            case "sepadirectdebit": {
                return SepaPaymentMethod.SERIALIZER;
            }
            case "afterpay_default": {
                return AfterPayPaymentMethod.SERIALIZER;
            }
            case "mbway": {
                return MBWayPaymentMethod.SERIALIZER;
            }
            case "blik": {
                return BlikPaymentMethod.SERIALIZER;
            }
        }
        return GenericPaymentMethod.SERIALIZER;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }
}

