/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.request;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.request.PaymentMethodDetails;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public class SepaPaymentMethod
extends PaymentMethodDetails {
    @NonNull
    public static final ModelObject.Creator<SepaPaymentMethod> CREATOR = new ModelObject.Creator(SepaPaymentMethod.class);
    public static final String PAYMENT_METHOD_TYPE = "sepadirectdebit";
    private static final String OWNER_NAME = "sepa.ownerName";
    private static final String IBAN_NUMBER = "sepa.ibanNumber";
    @NonNull
    public static final ModelObject.Serializer<SepaPaymentMethod> SERIALIZER = new ModelObject.Serializer<SepaPaymentMethod>(){

        @NonNull
        public JSONObject serialize(@NonNull SepaPaymentMethod modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt(SepaPaymentMethod.OWNER_NAME, (Object)modelObject.getOwnerName());
                jsonObject.putOpt(SepaPaymentMethod.IBAN_NUMBER, (Object)modelObject.getIbanNumber());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(SepaPaymentMethod.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public SepaPaymentMethod deserialize(@NonNull JSONObject jsonObject) {
            SepaPaymentMethod sepaPaymentMethod = new SepaPaymentMethod();
            sepaPaymentMethod.setType(jsonObject.optString("type", null));
            sepaPaymentMethod.setOwnerName(jsonObject.optString(SepaPaymentMethod.OWNER_NAME, null));
            sepaPaymentMethod.setIbanNumber(jsonObject.optString(SepaPaymentMethod.IBAN_NUMBER, null));
            return sepaPaymentMethod;
        }
    };
    private String ownerName;
    private String ibanNumber;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(@Nullable String ownerName) {
        this.ownerName = ownerName;
    }

    @Nullable
    public String getIbanNumber() {
        return this.ibanNumber;
    }

    public void setIbanNumber(@Nullable String ibanNumber) {
        this.ibanNumber = ibanNumber;
    }
}

