/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.response;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.adyen.checkout.base.model.payments.response.AwaitAction;
import com.adyen.checkout.base.model.payments.response.QrCodeAction;
import com.adyen.checkout.base.model.payments.response.RedirectAction;
import com.adyen.checkout.base.model.payments.response.SdkAction;
import com.adyen.checkout.base.model.payments.response.Threeds2ChallengeAction;
import com.adyen.checkout.base.model.payments.response.Threeds2FingerprintAction;
import com.adyen.checkout.base.model.payments.response.VoucherAction;
import com.adyen.checkout.base.model.payments.response.WeChatPaySdkAction;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONObject;

public abstract class Action
extends ModelObject {
    public static final String TYPE = "type";
    public static final String PAYMENT_DATA = "paymentData";
    public static final String PAYMENT_METHOD_TYPE = "paymentMethodType";
    @NonNull
    public static final ModelObject.Serializer<Action> SERIALIZER = new ModelObject.Serializer<Action>(){

        @NonNull
        public JSONObject serialize(@NonNull Action modelObject) {
            String actionType = modelObject.getType();
            if (TextUtils.isEmpty((CharSequence)actionType)) {
                throw new CheckoutException("Action type not found");
            }
            ModelObject.Serializer<? extends Action> serializer = Action.getChildSerializer(actionType);
            return serializer.serialize((ModelObject)modelObject);
        }

        @NonNull
        public Action deserialize(@NonNull JSONObject jsonObject) {
            String actionType = jsonObject.optString(Action.TYPE);
            if (TextUtils.isEmpty((CharSequence)actionType)) {
                throw new CheckoutException("Action type not found");
            }
            ModelObject.Serializer<? extends Action> serializer = Action.getChildSerializer(actionType);
            return (Action)serializer.deserialize(jsonObject);
        }
    };
    private String type;
    private String paymentData;
    private String paymentMethodType;

    @NonNull
    static ModelObject.Serializer<? extends Action> getChildSerializer(@NonNull String actionType) {
        switch (actionType) {
            case "redirect": {
                return RedirectAction.SERIALIZER;
            }
            case "threeDS2Fingerprint": {
                return Threeds2FingerprintAction.SERIALIZER;
            }
            case "threeDS2Challenge": {
                return Threeds2ChallengeAction.SERIALIZER;
            }
            case "qrCode": {
                return QrCodeAction.SERIALIZER;
            }
            case "voucher": {
                return VoucherAction.SERIALIZER;
            }
            case "wechatpaySDK": {
                return WeChatPaySdkAction.SERIALIZER;
            }
            case "sdk": {
                return SdkAction.SERIALIZER;
            }
            case "await": {
                return AwaitAction.SERIALIZER;
            }
        }
        throw new CheckoutException("Action type not found - " + actionType);
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @Nullable
    public String getPaymentData() {
        return this.paymentData;
    }

    public void setPaymentData(@Nullable String paymentData) {
        this.paymentData = paymentData;
    }

    @Nullable
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public void setPaymentMethodType(@Nullable String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }
}

