/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.response;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.response.Action;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public class QrCodeAction
extends Action {
    @NonNull
    public static final ModelObject.Creator<QrCodeAction> CREATOR = new ModelObject.Creator(QrCodeAction.class);
    public static final String ACTION_TYPE = "qrCode";
    private static final String QR_CODE_DATA = "qrCodeData";
    @NonNull
    public static final ModelObject.Serializer<QrCodeAction> SERIALIZER = new ModelObject.Serializer<QrCodeAction>(){

        @NonNull
        public JSONObject serialize(@NonNull QrCodeAction modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt("paymentData", (Object)modelObject.getPaymentData());
                jsonObject.putOpt("paymentMethodType", (Object)modelObject.getPaymentMethodType());
                jsonObject.putOpt(QrCodeAction.QR_CODE_DATA, (Object)modelObject.getQrCodeData());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(QrCodeAction.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public QrCodeAction deserialize(@NonNull JSONObject jsonObject) {
            QrCodeAction qrCodeAction = new QrCodeAction();
            qrCodeAction.setType(jsonObject.optString("type", null));
            qrCodeAction.setPaymentData(jsonObject.optString("paymentData", null));
            qrCodeAction.setPaymentMethodType(jsonObject.optString("paymentMethodType", null));
            qrCodeAction.setQrCodeData(jsonObject.optString(QrCodeAction.QR_CODE_DATA));
            return qrCodeAction;
        }
    };
    private String qrCodeData;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public String getQrCodeData() {
        return this.qrCodeData;
    }

    public void setQrCodeData(@Nullable String qrCodeData) {
        this.qrCodeData = qrCodeData;
    }
}

