/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.response;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.response.Action;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

public class RedirectAction
extends Action {
    @NonNull
    public static final ModelObject.Creator<RedirectAction> CREATOR = new ModelObject.Creator(RedirectAction.class);
    public static final String ACTION_TYPE = "redirect";
    private static final String METHOD = "method";
    private static final String URL = "url";
    @NonNull
    public static final ModelObject.Serializer<RedirectAction> SERIALIZER = new ModelObject.Serializer<RedirectAction>(){

        @NonNull
        public JSONObject serialize(@NonNull RedirectAction modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt("paymentData", (Object)modelObject.getPaymentData());
                jsonObject.putOpt("paymentMethodType", (Object)modelObject.getPaymentMethodType());
                jsonObject.putOpt(RedirectAction.METHOD, (Object)modelObject.getMethod());
                jsonObject.putOpt(RedirectAction.URL, (Object)modelObject.getUrl());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(RedirectAction.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public RedirectAction deserialize(@NonNull JSONObject jsonObject) {
            RedirectAction redirectAction = new RedirectAction();
            redirectAction.setType(jsonObject.optString("type", null));
            redirectAction.setPaymentData(jsonObject.optString("paymentData", null));
            redirectAction.setPaymentMethodType(jsonObject.optString("paymentMethodType", null));
            redirectAction.setMethod(jsonObject.optString(RedirectAction.METHOD, null));
            redirectAction.setUrl(jsonObject.optString(RedirectAction.URL, null));
            return redirectAction;
        }
    };
    private String method;
    private String url;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setMethod(@Nullable String method) {
        this.method = method;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }
}

