/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.response;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.response.Action;
import com.adyen.checkout.base.model.payments.response.SdkData;
import com.adyen.checkout.base.model.payments.response.WeChatPaySdkAction;
import com.adyen.checkout.base.model.payments.response.WeChatPaySdkData;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import com.adyen.checkout.core.model.ModelUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class SdkAction<SdkDataT extends SdkData>
extends Action {
    @NonNull
    public static final ModelObject.Creator<SdkAction> CREATOR = new ModelObject.Creator(SdkAction.class);
    public static final String ACTION_TYPE = "sdk";
    private static final String SDK_DATA = "sdkData";
    @NonNull
    public static final ModelObject.Serializer<SdkAction> SERIALIZER = new ModelObject.Serializer<SdkAction>(){

        @NonNull
        public JSONObject serialize(@NonNull SdkAction modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt("paymentData", (Object)modelObject.getPaymentData());
                jsonObject.putOpt("paymentMethodType", (Object)modelObject.getPaymentMethodType());
                ModelObject.Serializer<? extends SdkData> serializer = this.getSdkDataSerializer(modelObject.getPaymentMethodType());
                if (modelObject.getSdkData() != null) {
                    jsonObject.putOpt(SdkAction.SDK_DATA, (Object)ModelUtils.serializeOpt(modelObject.getSdkData(), serializer));
                }
            }
            catch (JSONException e) {
                throw new ModelSerializationException(WeChatPaySdkAction.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public SdkAction deserialize(@NonNull JSONObject jsonObject) {
            SdkAction<SdkData> sdkAction = new SdkAction<SdkData>();
            sdkAction.setType(jsonObject.optString("type", null));
            sdkAction.setPaymentData(jsonObject.optString("paymentData", null));
            sdkAction.setPaymentMethodType(jsonObject.optString("paymentMethodType", null));
            ModelObject.Serializer<? extends SdkData> serializer = this.getSdkDataSerializer(sdkAction.getPaymentMethodType());
            sdkAction.setSdkData((SdkData)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(SdkAction.SDK_DATA), serializer));
            return sdkAction;
        }

        @NonNull
        private ModelObject.Serializer<? extends SdkData> getSdkDataSerializer(@Nullable String paymentMethodType) {
            if (paymentMethodType == null) {
                throw new CheckoutException("SdkAction cannot be parsed with null paymentMethodType.");
            }
            switch (paymentMethodType) {
                case "wechatpaySDK": {
                    return WeChatPaySdkData.SERIALIZER;
                }
            }
            throw new CheckoutException("sdkData not found for type paymentMethodType - " + paymentMethodType);
        }
    };
    private SdkDataT sdkData;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public SdkDataT getSdkData() {
        return this.sdkData;
    }

    public void setSdkData(@Nullable SdkDataT sdkData) {
        this.sdkData = sdkData;
    }
}

