/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.model.payments.response;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.base.model.payments.response.Action;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import com.adyen.checkout.core.model.ModelUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class VoucherAction
extends Action {
    @NonNull
    public static final ModelObject.Creator<VoucherAction> CREATOR = new ModelObject.Creator(VoucherAction.class);
    public static final String ACTION_TYPE = "voucher";
    private static final String SURCHARGE = "surcharge";
    private static final String INITIAL_AMOUNT = "initialAmount";
    private static final String TOTAL_AMOUNT = "totalAmount";
    private static final String ISSUER = "issuer";
    private static final String EXPIRES_AT = "expiresAt";
    private static final String REFERENCE = "reference";
    private static final String ALTERNATIVE_REFERENCE = "alternativeReference";
    private static final String MERCHANT_NAME = "merchantName";
    @NonNull
    public static final ModelObject.Serializer<VoucherAction> SERIALIZER = new ModelObject.Serializer<VoucherAction>(){

        @NonNull
        public JSONObject serialize(@NonNull VoucherAction modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt("type", (Object)modelObject.getType());
                jsonObject.putOpt("paymentData", (Object)modelObject.getPaymentData());
                jsonObject.putOpt("paymentMethodType", (Object)modelObject.getPaymentMethodType());
                jsonObject.putOpt(VoucherAction.SURCHARGE, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getSurcharge(), Amount.SERIALIZER));
                jsonObject.putOpt(VoucherAction.INITIAL_AMOUNT, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getInitialAmount(), Amount.SERIALIZER));
                jsonObject.putOpt(VoucherAction.TOTAL_AMOUNT, (Object)ModelUtils.serializeOpt((ModelObject)modelObject.getTotalAmount(), Amount.SERIALIZER));
                jsonObject.putOpt(VoucherAction.ISSUER, (Object)modelObject.getIssuer());
                jsonObject.putOpt(VoucherAction.EXPIRES_AT, (Object)modelObject.getExpiresAt());
                jsonObject.putOpt(VoucherAction.REFERENCE, (Object)modelObject.getReference());
                jsonObject.putOpt(VoucherAction.ALTERNATIVE_REFERENCE, (Object)modelObject.getAlternativeReference());
                jsonObject.putOpt(VoucherAction.MERCHANT_NAME, (Object)modelObject.getMerchantName());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(VoucherAction.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public VoucherAction deserialize(@NonNull JSONObject jsonObject) {
            VoucherAction voucherAction = new VoucherAction();
            voucherAction.setType(jsonObject.optString("type", null));
            voucherAction.setPaymentData(jsonObject.optString("paymentData", null));
            voucherAction.setPaymentMethodType(jsonObject.optString("paymentMethodType", null));
            voucherAction.setSurcharge((Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(VoucherAction.SURCHARGE), Amount.SERIALIZER));
            voucherAction.setInitialAmount((Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(VoucherAction.INITIAL_AMOUNT), Amount.SERIALIZER));
            voucherAction.setTotalAmount((Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject(VoucherAction.TOTAL_AMOUNT), Amount.SERIALIZER));
            voucherAction.setIssuer(jsonObject.optString(VoucherAction.ISSUER));
            voucherAction.setExpiresAt(jsonObject.optString(VoucherAction.EXPIRES_AT));
            voucherAction.setReference(jsonObject.optString(VoucherAction.REFERENCE));
            voucherAction.setAlternativeReference(jsonObject.optString(VoucherAction.ALTERNATIVE_REFERENCE));
            voucherAction.setMerchantName(jsonObject.optString(VoucherAction.MERCHANT_NAME));
            return voucherAction;
        }
    };
    private Amount surcharge;
    private Amount initialAmount;
    private Amount totalAmount;
    private String issuer;
    private String expiresAt;
    private String reference;
    private String alternativeReference;
    private String merchantName;

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }

    @Nullable
    public Amount getSurcharge() {
        return this.surcharge;
    }

    public void setSurcharge(@Nullable Amount surcharge) {
        this.surcharge = surcharge;
    }

    @Nullable
    public Amount getInitialAmount() {
        return this.initialAmount;
    }

    public void setInitialAmount(@Nullable Amount initialAmount) {
        this.initialAmount = initialAmount;
    }

    @Nullable
    public Amount getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(@Nullable Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@Nullable String issuer) {
        this.issuer = issuer;
    }

    @Nullable
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(@Nullable String expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Nullable
    public String getReference() {
        return this.reference;
    }

    public void setReference(@Nullable String reference) {
        this.reference = reference;
    }

    @Nullable
    public String getAlternativeReference() {
        return this.alternativeReference;
    }

    public void setAlternativeReference(@Nullable String alternativeReference) {
        this.alternativeReference = alternativeReference;
    }

    @Nullable
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(@Nullable String merchantName) {
        this.merchantName = merchantName;
    }
}

