/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.util;

import android.support.annotation.NonNull;
import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.base.util.CheckoutCurrency;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.NoConstructorException;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Locale;

public final class AmountFormat {
    private static final String TAG = LogUtil.getTag();

    @NonNull
    public static BigDecimal toBigDecimal(@NonNull Amount amount) {
        return AmountFormat.toBigDecimal(amount.getValue(), amount.getCurrency());
    }

    @NonNull
    public static BigDecimal toBigDecimal(long value, @NonNull String currencyCode) {
        int fractionDigits = AmountFormat.getFractionDigits(currencyCode);
        return BigDecimal.valueOf(value, fractionDigits);
    }

    private static int getFractionDigits(@NonNull String currencyCode) {
        String normalizedCurrencyCode = currencyCode.replaceAll("[^A-Z]", "").toUpperCase(Locale.ROOT);
        try {
            CheckoutCurrency checkoutCurrency = CheckoutCurrency.find(normalizedCurrencyCode);
            return checkoutCurrency.getFractionDigits();
        }
        catch (CheckoutException e) {
            Logger.e((String)TAG, (String)(normalizedCurrencyCode + " is an unsupported currency. Falling back to information from java.util.Currency."), (Throwable)e);
            try {
                Currency currency = Currency.getInstance(normalizedCurrencyCode);
                return Math.max(currency.getDefaultFractionDigits(), 0);
            }
            catch (IllegalArgumentException e2) {
                Logger.e((String)TAG, (String)("Could not determine fraction digits for " + normalizedCurrencyCode), (Throwable)e2);
                return 0;
            }
        }
    }

    private AmountFormat() {
        throw new NoConstructorException();
    }
}

