/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.base.util.CheckoutCurrency;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.NoConstructorException;
import com.adyen.checkout.core.log.LogUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;

public final class CurrencyUtils {
    public static final String TAG = LogUtil.getTag();

    @NonNull
    public static String formatAmount(@NonNull Amount amount, @NonNull Locale locale) {
        String currencyCode = amount.getCurrency();
        CheckoutCurrency checkoutCurrency = CheckoutCurrency.find(currencyCode);
        Currency currency = Currency.getInstance(currencyCode);
        NumberFormat currencyFormat = DecimalFormat.getCurrencyInstance(locale);
        currencyFormat.setCurrency(currency);
        currencyFormat.setMinimumFractionDigits(checkoutCurrency.getFractionDigits());
        currencyFormat.setMaximumFractionDigits(checkoutCurrency.getFractionDigits());
        BigDecimal value = BigDecimal.valueOf(amount.getValue(), checkoutCurrency.getFractionDigits());
        return currencyFormat.format(value);
    }

    static void assertCurrency(@Nullable String currencyCode) {
        if (!CheckoutCurrency.isSupported(currencyCode)) {
            throw new CheckoutException("Currency " + currencyCode + " not supported");
        }
    }

    private CurrencyUtils() {
        throw new NoConstructorException();
    }
}

