/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.util;

import android.support.annotation.NonNull;
import com.adyen.checkout.core.exception.NoConstructorException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class DateUtils {
    private static final int FOUR_DIGIT = 4;
    private static final int START_OF_FOUR_DIGIT_INDEX = 2;
    private static final SimpleDateFormat SERVER_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);

    private DateUtils() {
        throw new NoConstructorException();
    }

    @NonNull
    public static String removeFirstTwoDigitFromYear(@NonNull String fourDigitYear) {
        if (fourDigitYear.length() == 4) {
            return fourDigitYear.substring(2, 4);
        }
        return fourDigitYear;
    }

    @NonNull
    public static Calendar parseServerDateFormat(@NonNull String dateValue) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = SERVER_DATE_FORMAT.parse(dateValue);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            return calendar;
        }
    }

    @NonNull
    public static String toServerDateFormat(@NonNull Calendar calendar) {
        return SERVER_DATE_FORMAT.format(calendar.getTime());
    }
}

