/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.util;

import android.support.annotation.NonNull;
import com.adyen.checkout.core.exception.NoConstructorException;
import java.util.regex.Pattern;

public final class ValidationUtils {
    private static final String EMAIL_REGEX = "^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$", 2);
    private static final String PHONE_REGEX = "^\\D*(\\d\\D*){9,14}$";
    private static final Pattern PHONE_PATTERN = Pattern.compile("^\\D*(\\d\\D*){9,14}$");
    private static final String CLIENT_KEY_REGEX = "([a-z]){4}\\_([A-z]|\\d){32}";
    private static final Pattern CLIENT_KEY_PATTERN = Pattern.compile("([a-z]){4}\\_([A-z]|\\d){32}");

    private ValidationUtils() {
        throw new NoConstructorException();
    }

    @NonNull
    public static boolean isPhoneNumberValid(@NonNull String phoneNumber) {
        return PHONE_PATTERN.matcher(phoneNumber).matches();
    }

    @NonNull
    public static boolean isEmailValid(@NonNull String emailAddress) {
        return EMAIL_PATTERN.matcher(emailAddress).matches();
    }

    public static boolean isClientKeyValid(@NonNull String clientKey) {
        return CLIENT_KEY_PATTERN.matcher(clientKey).matches();
    }
}

