/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.adyen.checkout.base.api.ImageLoader;
import com.adyen.checkout.base.ui.view.RoundCornerImageView;
import com.adyen.checkout.card.model.CardType;
import com.adyen.checkout.card.ui.R;
import java.util.Collections;
import java.util.List;

public class CardListAdapter
extends RecyclerView.Adapter<ImageViewHolder> {
    private List<CardType> mCards = Collections.emptyList();
    private final ImageLoader mImageLoader;

    CardListAdapter(ImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
    }

    @NonNull
    public ImageViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        Resources resources = parent.getResources();
        int width = resources.getDimensionPixelSize(R.dimen.payment_method_logo_width);
        int height = resources.getDimensionPixelSize(R.dimen.payment_method_logo_height);
        int leftMargin = resources.getDimensionPixelSize(R.dimen.standard_quarter_margin);
        RecyclerView.LayoutParams layoutParams = new RecyclerView.LayoutParams(width, height);
        layoutParams.leftMargin = leftMargin;
        RoundCornerImageView imageView = new RoundCornerImageView(parent.getContext());
        imageView.setStrokeColor(ContextCompat.getColor((Context)parent.getContext(), (int)R.color.stroke_color));
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return new ImageViewHolder((View)imageView);
    }

    public void onBindViewHolder(@NonNull ImageViewHolder imageViewHolder, int i) {
        this.mImageLoader.load(this.mCards.get(i).getTxVariant(), (ImageView)imageViewHolder.mCardLogo);
    }

    public int getItemCount() {
        return this.mCards.size();
    }

    void setCards(@NonNull List<CardType> cards) {
        this.mCards = cards;
        this.notifyDataSetChanged();
    }

    class ImageViewHolder
    extends RecyclerView.ViewHolder {
        RoundCornerImageView mCardLogo;

        ImageViewHolder(View view) {
            super(view);
            this.mCardLogo = (RoundCornerImageView)view;
        }
    }
}

