/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SwitchCompat;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import com.adyen.checkout.base.ComponentView;
import com.adyen.checkout.base.api.ImageLoader;
import com.adyen.checkout.base.component.data.input.InputData;
import com.adyen.checkout.base.component.validator.Validity;
import com.adyen.checkout.card.CardComponent;
import com.adyen.checkout.card.CardListAdapter;
import com.adyen.checkout.card.data.input.CardInputData;
import com.adyen.checkout.card.data.output.CardNumberField;
import com.adyen.checkout.card.data.output.CardOutputData;
import com.adyen.checkout.card.data.output.ExpiryDateField;
import com.adyen.checkout.card.data.validator.ExpiryDateValidator;
import com.adyen.checkout.card.data.validator.HolderNameValidator;
import com.adyen.checkout.card.data.validator.NumberValidator;
import com.adyen.checkout.card.data.validator.SecurityCodeValidator;
import com.adyen.checkout.card.model.CardType;
import com.adyen.checkout.card.ui.AdyenTextInputEditText;
import com.adyen.checkout.card.ui.CardNumberInput;
import com.adyen.checkout.card.ui.ExpiryDateInput;
import com.adyen.checkout.card.ui.R;
import com.adyen.checkout.card.ui.SecurityCodeInput;
import com.adyen.checkout.core.api.Environment;

public final class CardView
extends LinearLayout
implements ComponentView<CardComponent>,
Observer<CardOutputData> {
    private RecyclerView mCardListRecyclerView;
    private CardListAdapter mCardListAdapter;
    private final CardNumberInput mCardNumberEditText;
    private final ExpiryDateInput mExpiryDateEditText;
    private final TextInputLayout mExpiryDateInput;
    private final TextInputLayout mSecurityCodeInput;
    private final TextInputLayout mCardNumberInput;
    private final TextInputLayout mCardHolderInput;
    private final SwitchCompat mStorePaymentMethod;
    private final CardInputData mCardInputData;
    @Nullable
    private CardComponent mComponent;

    public CardView(@NonNull Context context) {
        this(context, null);
    }

    public CardView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        LayoutInflater.from((Context)context).inflate(R.layout.card_view, (ViewGroup)this, true);
        int padding = (int)this.getResources().getDimension(R.dimen.standard_margin);
        this.setPadding(padding, padding, padding, 0);
        this.mCardListRecyclerView = (RecyclerView)this.findViewById(R.id.recyclerView_cardList);
        this.mCardListRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        this.mStorePaymentMethod = (SwitchCompat)this.findViewById(R.id.switch_storePaymentMethod);
        this.mCardNumberInput = (TextInputLayout)this.findViewById(R.id.textInputLayout_cardNumber);
        this.mCardNumberEditText = (CardNumberInput)this.mCardNumberInput.getEditText();
        this.mCardNumberEditText.setOnChangeListener(new AdyenTextInputEditText.Listener(){

            @Override
            public void onTextChanged(Editable editable) {
                CardView.this.mCardInputData.setCardNumber(CardView.this.mCardNumberEditText.getRawValue());
                CardView.this.notifyInputDataChanged();
            }
        });
        this.mCardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                CardView.this.mCardNumberInput.setErrorEnabled(!hasFocus);
                if (!(hasFocus || !CardView.this.isOutputEmpty() && ((NumberValidator.NumberValidationResult)CardView.this.mComponent.getOutputData().getCardNumberField().getValidationResult()).isValid())) {
                    CardView.this.mCardNumberInput.setError((CharSequence)CardView.this.getContext().getString(R.string.checkout_card_number_not_valid));
                }
            }
        });
        this.mStorePaymentMethod.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                CardView.this.mCardInputData.setStorePayment(isChecked);
                CardView.this.notifyInputDataChanged();
            }
        });
        this.mExpiryDateInput = (TextInputLayout)this.findViewById(R.id.textInputLayout_expiryDate);
        this.mExpiryDateEditText = (ExpiryDateInput)this.mExpiryDateInput.getEditText();
        this.mExpiryDateEditText.setOnChangeListener(new AdyenTextInputEditText.Listener(){

            @Override
            public void onTextChanged(Editable editable) {
                CardView.this.mCardInputData.setExpiryDate(CardView.this.mExpiryDateEditText.getRawValue());
                CardView.this.notifyInputDataChanged();
            }
        });
        this.mExpiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                CardView.this.mExpiryDateInput.setErrorEnabled(!hasFocus);
                if (!(hasFocus || !CardView.this.isOutputEmpty() && ((ExpiryDateValidator.ExpiryDateValidationResult)CardView.this.mComponent.getOutputData().getExpiryDateField().getValidationResult()).isValid())) {
                    CardView.this.mExpiryDateInput.setError((CharSequence)CardView.this.getContext().getString(R.string.checkout_expiry_date_not_valid));
                }
            }
        });
        this.mSecurityCodeInput = (TextInputLayout)this.findViewById(R.id.textInputLayout_securityCode);
        SecurityCodeInput securityCodeEditText = (SecurityCodeInput)this.mSecurityCodeInput.getEditText();
        securityCodeEditText.setOnChangeListener(new AdyenTextInputEditText.Listener(){

            @Override
            public void onTextChanged(Editable editable) {
                CardView.this.mCardInputData.setSecurityCode(editable.toString());
                CardView.this.notifyInputDataChanged();
            }
        });
        securityCodeEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                CardView.this.mSecurityCodeInput.setErrorEnabled(!hasFocus);
                if (!(hasFocus || !CardView.this.isOutputEmpty() && ((SecurityCodeValidator.SecurityCodeValidationResult)CardView.this.mComponent.getOutputData().getSecurityCodeField().getValidationResult()).isValid())) {
                    CardView.this.mSecurityCodeInput.setError((CharSequence)CardView.this.getContext().getString(R.string.checkout_security_code_not_valid));
                }
            }
        });
        this.mCardHolderInput = (TextInputLayout)this.findViewById(R.id.textInputLayout_cardHolder);
        AdyenTextInputEditText cardHolderEditText = (AdyenTextInputEditText)this.mCardHolderInput.getEditText();
        cardHolderEditText.setOnChangeListener(new AdyenTextInputEditText.Listener(){

            @Override
            public void onTextChanged(Editable editable) {
                CardView.this.mCardInputData.setHolderName(editable.toString());
                CardView.this.notifyInputDataChanged();
            }
        });
        cardHolderEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                CardView.this.mCardHolderInput.setErrorEnabled(!hasFocus);
                if (!(hasFocus || !CardView.this.isOutputEmpty() && ((HolderNameValidator.HolderNameValidationResult)CardView.this.mComponent.getOutputData().getHolderNameField().getValidationResult()).isValid())) {
                    CardView.this.mCardHolderInput.setError((CharSequence)CardView.this.getContext().getString(R.string.checkout_holder_name_not_valid));
                }
            }
        });
        this.mCardInputData = new CardInputData();
    }

    public void onChanged(@NonNull CardOutputData cardOutputData) {
        if (!cardOutputData.isEmpty()) {
            this.onCardNumberValidated(cardOutputData.getCardNumberField());
            this.onExpiryDateValidated(cardOutputData.getExpiryDateField());
        }
        if (this.mComponent.isStoredPaymentMethod()) {
            this.mSecurityCodeInput.getEditText().requestFocus();
        }
    }

    public void attach(@NonNull CardComponent component, @NonNull LifecycleOwner lifecycleOwner) {
        this.mComponent = component;
        if (this.mComponent.isStoredPaymentMethod()) {
            CardInputData storedCardInput = this.mComponent.getStoredPaymentInputData();
            this.mCardNumberEditText.setText(this.getContext().getString(R.string.card_number_4digit, new Object[]{storedCardInput.getCardNumber()}));
            this.mCardNumberEditText.setEnabled(false);
            this.mExpiryDateEditText.setText(storedCardInput.getExpiryDate());
            this.mExpiryDateEditText.setEnabled(false);
            this.mStorePaymentMethod.setVisibility(8);
            this.mCardHolderInput.setVisibility(8);
        } else {
            this.mCardHolderInput.setVisibility(this.mComponent.isHolderNameRequire() ? 0 : 8);
            this.mStorePaymentMethod.setVisibility(this.mComponent.showStorePaymentField() ? 0 : 8);
        }
        this.mCardListAdapter = new CardListAdapter(ImageLoader.getInstance((Context)this.getContext(), (Environment)component.getConfiguration().getEnvironment()));
        this.mComponent.observeOutputData(lifecycleOwner, (Observer)this);
        this.mCardListAdapter.setCards(this.mComponent.getSupportedFilterCards(null));
        this.mCardListRecyclerView.setAdapter((RecyclerView.Adapter)this.mCardListAdapter);
        this.mComponent.sendAnalyticsEvent(this.getContext());
    }

    public boolean isConfirmationRequired() {
        return true;
    }

    private void notifyInputDataChanged() {
        if (this.mComponent != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    CardView.this.mComponent.inputDataChanged((InputData)CardView.this.mCardInputData);
                }
            });
        }
    }

    private void onCardNumberValidated(@Nullable CardNumberField number) {
        if (number != null) {
            NumberValidator.NumberValidationResult result = (NumberValidator.NumberValidationResult)number.getValidationResult();
            if (result.getValidity() == Validity.VALID) {
                this.changeFocusOfInput(result.getNumber());
            }
            this.mCardListAdapter.setCards(this.mComponent.getSupportedFilterCards(result.getNumber()));
        }
    }

    private void onExpiryDateValidated(@Nullable ExpiryDateField expiryDate) {
        ExpiryDateValidator.ExpiryDateValidationResult result;
        if (expiryDate != null && (result = (ExpiryDateValidator.ExpiryDateValidationResult)expiryDate.getValidationResult()).getValidity() == Validity.VALID) {
            this.goToNextInputIfFocus((View)this.mExpiryDateEditText);
        }
    }

    private boolean isOutputEmpty() {
        return this.mComponent.getOutputData().isEmpty();
    }

    private void changeFocusOfInput(String numberValue) {
        int length = numberValue.length();
        if (length == 16 || length == 15 && CardType.estimate((String)numberValue).contains(CardType.AMERICAN_EXPRESS)) {
            this.goToNextInputIfFocus((View)this.mCardNumberEditText);
        }
    }

    private void goToNextInputIfFocus(View view) {
        if (this.getRootView().findFocus() == view) {
            this.findViewById(view.getNextFocusForwardId()).requestFocus();
        }
    }
}

