/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.ui;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.TextInputEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;

public class AdyenTextInputEditText
extends TextInputEditText {
    @Nullable
    private Listener mListener;

    public AdyenTextInputEditText(@NonNull Context context) {
        this(context, null);
    }

    public AdyenTextInputEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AdyenTextInputEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr == 0 ? R.attr.editTextStyle : defStyleAttr);
        this.addTextChangedListener(this.getTextWatcher());
    }

    public void setOnChangeListener(@NonNull Listener listener) {
        this.mListener = listener;
    }

    @NonNull
    public String getRawValue() {
        return this.getText().toString();
    }

    @CallSuper
    protected void afterTextChanged(@NonNull Editable editable) {
        if (this.mListener != null) {
            this.mListener.onTextChanged(editable);
        }
    }

    @NonNull
    private TextWatcher getTextWatcher() {
        return new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AdyenTextInputEditText.this.afterTextChanged(s);
            }
        };
    }

    public static interface Listener {
        public void onTextChanged(@NonNull Editable var1);
    }
}

