/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.util.AttributeSet;
import com.adyen.checkout.card.ui.NumberInputEditText;

public class CardNumberInput
extends NumberInputEditText {
    private static final int MAX_DIGIT_LENGTH = 19;
    private static final int MAX_DIGIT_SEPARATOR_COUNT = 4;
    private static final char DIGIT_SEPARATOR = ' ';

    public CardNumberInput(@NonNull Context context) {
        this(context, null);
    }

    public CardNumberInput(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardNumberInput(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public int maxLength() {
        return 23;
    }

    @Override
    @NonNull
    public String getRawValue() {
        return this.getText().toString().replace(" ", "");
    }

    @Override
    protected void afterTextChanged(@NonNull Editable editable) {
        String initial = editable.toString();
        String processed = initial.trim();
        if (!initial.equals(processed = processed.replaceAll("(\\d{4})(?=\\d)", "$1 "))) {
            editable.replace(0, initial.length(), (CharSequence)processed);
        }
        super.afterTextChanged(editable);
    }
}

