/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.util.AttributeSet;
import com.adyen.checkout.card.ui.NumberInputEditText;

public class ExpiryDateInput
extends NumberInputEditText {
    private static final int MAX_LENGTH = 5;
    private static final char DATE_SEPARATOR = '/';
    private static final int ONE_DIGIT_MONTH = 1;

    public ExpiryDateInput(@NonNull Context context) {
        this(context, null);
    }

    public ExpiryDateInput(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpiryDateInput(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public int maxLength() {
        return 5;
    }

    @Override
    public void afterTextChanged(@NonNull Editable editable) {
        String initial = editable.toString();
        String processed = initial.replaceAll("\\D", "");
        if ((processed = processed.replaceAll("(\\d{2})(?=\\d)", "$1/")).length() == 1 && this.isStringInt(processed) && Integer.parseInt(processed) > 1) {
            processed = "0" + processed;
        }
        if (!initial.equals(processed)) {
            editable.replace(0, initial.length(), (CharSequence)processed);
        }
        super.afterTextChanged(editable);
    }

    @Override
    @NonNull
    public String getRawValue() {
        return this.getText().toString().replace("/", "");
    }

    private boolean isStringInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

