/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.cse.internal;

import adyen.com.adyencse.encrypter.exception.EncrypterException;
import adyen.com.adyencse.pojo.Card;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.adyen.checkout.cse.Card;
import com.adyen.checkout.cse.CardEncryptor;
import com.adyen.checkout.cse.EncryptedCard;
import com.adyen.checkout.cse.EncryptionException;
import java.util.Date;

public final class CardEncryptorImpl
implements CardEncryptor {
    @Override
    @WorkerThread
    @NonNull
    public EncryptedCard encryptFields(@NonNull Card card, @NonNull String publicKey) throws EncryptionException {
        try {
            String encryptedExpiryYear;
            String encryptedExpiryMonth;
            Date generationTime = new Date();
            String cardNumber = card.getNumber();
            String encryptedNumber = null;
            if (cardNumber != null) {
                try {
                    encryptedNumber = new Card.Builder().setNumber(cardNumber).setGenerationTime(generationTime).build().serialize(publicKey);
                }
                catch (RuntimeException e) {
                    throw new EncryptionException("Encryption failed.", e);
                }
            }
            Integer expiryMonth = card.getExpiryMonth();
            Integer expiryYear = card.getExpiryYear();
            if (expiryMonth != null && expiryYear != null) {
                encryptedExpiryMonth = new Card.Builder().setExpiryMonth(String.valueOf(expiryMonth)).setGenerationTime(generationTime).build().serialize(publicKey);
                encryptedExpiryYear = new Card.Builder().setExpiryYear(String.valueOf(expiryYear)).setGenerationTime(generationTime).build().serialize(publicKey);
            } else if (expiryMonth == null && expiryYear == null) {
                encryptedExpiryMonth = null;
                encryptedExpiryYear = null;
            } else {
                throw new EncryptionException("Both expiryMonth and expiryYear need to be set for encryption.", null);
            }
            String encryptedSecurityCode = new Card.Builder().setCvc(card.getSecurityCode()).setGenerationTime(generationTime).build().serialize(publicKey);
            EncryptedCard.Builder builder = new EncryptedCard.Builder().setEncryptedNumber(encryptedNumber);
            if (encryptedExpiryMonth != null && encryptedExpiryYear != null) {
                builder.setEncryptedExpiryDate(encryptedExpiryMonth, encryptedExpiryYear);
            } else {
                builder.clearEncryptedExpiryDate();
            }
            return builder.setEncryptedSecurityCode(encryptedSecurityCode).build();
        }
        catch (EncrypterException | IllegalStateException e) {
            throw new EncryptionException(e.getMessage(), e.getCause());
        }
    }

    @Override
    @NonNull
    @WorkerThread
    public String encrypt(@NonNull String holderName, @NonNull Card card, @NonNull String publicKey) throws EncrypterException {
        Date generationTime = new Date();
        Integer expiryMonth = card.getExpiryMonth();
        Integer expiryYear = card.getExpiryYear();
        String expiryMonthString = expiryMonth != null ? String.valueOf(expiryMonth) : null;
        String expiryYearString = expiryYear != null ? String.valueOf(expiryYear) : null;
        return new Card.Builder().setHolderName(holderName).setNumber(card.getNumber()).setExpiryMonth(expiryMonthString).setExpiryYear(expiryYearString).setCvc(card.getSecurityCode()).setGenerationTime(generationTime).build().serialize(publicKey);
    }
}

