/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.wechatpay;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.adyen.checkout.core.PaymentMethodHandler;
import com.adyen.checkout.core.PaymentReference;
import com.adyen.checkout.core.model.PaymentMethod;
import com.adyen.checkout.core.model.PaymentSession;
import com.adyen.checkout.wechatpay.internal.WeChatPayDetailsActivity;
import com.adyen.checkout.wechatpay.internal.WeChatPayUtil;

public final class WeChatPayHandler
implements PaymentMethodHandler {
    @NonNull
    public static final PaymentMethodHandler.Factory FACTORY = new PaymentMethodHandler.Factory(){

        public boolean supports(@NonNull Application application, @NonNull PaymentMethod paymentMethod) {
            return "wechatpaySDK".equals(paymentMethod.getType());
        }

        public boolean isAvailableToShopper(@NonNull Application application, @NonNull PaymentSession paymentSession, @NonNull PaymentMethod paymentMethod) {
            return WeChatPayUtil.isAvailable((Context)application);
        }
    };
    private final PaymentReference mPaymentReference;
    private final PaymentMethod mPaymentMethod;

    public WeChatPayHandler(@NonNull PaymentReference paymentReference, @NonNull PaymentMethod paymentMethod) {
        this.mPaymentReference = paymentReference;
        this.mPaymentMethod = paymentMethod;
    }

    public void handlePaymentMethodDetails(@NonNull Activity activity, int requestCode) {
        activity.finishActivity(requestCode);
        Intent intent = WeChatPayDetailsActivity.newIntent((Context)activity, this.mPaymentReference, this.mPaymentMethod);
        activity.startActivityForResult(intent, requestCode);
    }
}

