/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.wechatpay.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.core.AdditionalDetails;
import com.adyen.checkout.core.CheckoutException;
import com.adyen.checkout.core.Observer;
import com.adyen.checkout.core.PaymentHandler;
import com.adyen.checkout.core.PaymentReference;
import com.adyen.checkout.core.PaymentResult;
import com.adyen.checkout.core.handler.AdditionalDetailsHandler;
import com.adyen.checkout.core.handler.ErrorHandler;
import com.adyen.checkout.core.model.PaymentMethod;
import com.adyen.checkout.core.model.PaymentMethodDetails;
import com.adyen.checkout.core.model.WeChatPayDetails;
import com.adyen.checkout.core.model.WeChatPaySdkRedirectData;
import com.adyen.checkout.wechatpay.internal.WeChatPayListener;
import com.adyen.checkout.wechatpay.internal.WeChatPayProvider;
import com.adyen.checkout.wechatpay.internal.WeChatPayUtil;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import java.io.Serializable;

public class WeChatPayDetailsActivity
extends Activity
implements WeChatPayListener {
    private static final String EXTRA_PAYMENT_REFERENCE = "EXTRA_PAYMENT_REFERENCE";
    private static final String EXTRA_PAYMENT_METHOD = "EXTRA_PAYMENT_METHOD";
    private PaymentReference mPaymentReference;
    private PaymentHandler mPaymentHandler;
    private PaymentMethod mPaymentMethod;
    private WeChatPayUtil mWeChatPayUtil;

    @NonNull
    public static Intent newIntent(@NonNull Context context, @NonNull PaymentReference paymentReference, @NonNull PaymentMethod paymentMethod) {
        Intent intent = new Intent(context, WeChatPayDetailsActivity.class);
        intent.putExtra(EXTRA_PAYMENT_REFERENCE, (Parcelable)paymentReference);
        intent.putExtra(EXTRA_PAYMENT_METHOD, (Parcelable)paymentMethod);
        return intent;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mPaymentReference = (PaymentReference)intent.getParcelableExtra(EXTRA_PAYMENT_REFERENCE);
        this.mPaymentMethod = (PaymentMethod)intent.getParcelableExtra(EXTRA_PAYMENT_METHOD);
        if (!"wechatpaySDK".equals(this.mPaymentMethod.getType())) {
            throw new RuntimeException("Invalid PaymentMethod: " + this.mPaymentMethod);
        }
        this.mPaymentHandler = this.mPaymentReference.getPaymentHandler((Activity)this);
        this.mPaymentHandler.setAdditionalDetailsHandler((Activity)this, new AdditionalDetailsHandler(){

            public void onAdditionalDetailsRequired(@NonNull AdditionalDetails additionalDetails) {
                try {
                    WeChatPaySdkRedirectData redirectData = (WeChatPaySdkRedirectData)additionalDetails.getRedirectData(WeChatPaySdkRedirectData.class);
                    if (!WeChatPayDetailsActivity.this.mWeChatPayUtil.initiateWeChatPayRedirect(redirectData)) {
                        CheckoutException checkoutException = new CheckoutException.Builder("Could not redirect to WeChat app.", null).build();
                        Intent resultData = new Intent();
                        resultData.putExtra("RESULT_CHECKOUT_EXCEPTION", (Serializable)((Object)checkoutException));
                        WeChatPayDetailsActivity.this.setResult(1, resultData);
                        WeChatPayDetailsActivity.this.finish();
                    }
                }
                catch (CheckoutException e) {
                    Intent resultData = new Intent();
                    resultData.putExtra("RESULT_CHECKOUT_EXCEPTION", (Serializable)((Object)e));
                    WeChatPayDetailsActivity.this.setResult(1, resultData);
                    WeChatPayDetailsActivity.this.finish();
                }
            }
        });
        this.mPaymentHandler.setErrorHandler((Activity)this, new ErrorHandler(){

            public void onError(@NonNull CheckoutException error) {
                Intent resultData = new Intent();
                resultData.putExtra("RESULT_CHECKOUT_EXCEPTION", (Serializable)error);
                WeChatPayDetailsActivity.this.setResult(1, resultData);
                WeChatPayDetailsActivity.this.finish();
            }
        });
        this.mPaymentHandler.getPaymentResultObservable().observe((Activity)this, (Observer)new Observer<PaymentResult>(){

            public void onChanged(@NonNull PaymentResult paymentResult) {
                Intent resultData = new Intent();
                resultData.putExtra("RESULT_PAYMENT_RESULT", (Parcelable)paymentResult);
                WeChatPayDetailsActivity.this.setResult(-1, resultData);
                WeChatPayDetailsActivity.this.finish();
            }
        });
        WeChatPayProvider weChatPayProvider = new WeChatPayProvider.Builder().callbackActivity(WeChatPayDetailsActivity.class).build();
        this.mWeChatPayUtil = WeChatPayUtil.get(this.getApplication(), weChatPayProvider, this);
        if (savedInstanceState == null) {
            this.mPaymentHandler.initiatePayment(this.mPaymentMethod, null);
        }
    }

    protected void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.mWeChatPayUtil.handleIntent(intent);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mWeChatPayUtil.detach();
        this.mWeChatPayUtil = null;
    }

    @Override
    public void onPaymentDetails(@NonNull BaseResp baseResp, @NonNull WeChatPayDetails weChatPayDetails) {
        this.mPaymentHandler.submitAdditionalDetails((PaymentMethodDetails)weChatPayDetails);
    }
}

