/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.wechatpay.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import com.adyen.checkout.core.model.WeChatPayDetails;
import com.adyen.checkout.core.model.WeChatPaySdkRedirectData;
import com.adyen.checkout.wechatpay.internal.WeChatPayListener;
import com.adyen.checkout.wechatpay.internal.WeChatPayProvider;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import java.lang.ref.WeakReference;

public final class WeChatPayUtil
implements IWXAPIEventHandler {
    private final WeChatPayProvider mProvider;
    private final WeakReference<WeChatPayListener> mListenerWeakReference;
    private final IWXAPI mApi;

    public static boolean isAvailable(@NonNull Context context) {
        IWXAPI api = WXAPIFactory.createWXAPI((Context)context.getApplicationContext(), null, (boolean)true);
        boolean isAppInstalled = api.isWXAppInstalled();
        boolean isSupported = 0x22000001 <= api.getWXAppSupportAPI();
        api.detach();
        return isAppInstalled && isSupported;
    }

    @NonNull
    public static WeChatPayUtil get(@NonNull Application application, @NonNull WeChatPayProvider provider, @NonNull WeChatPayListener listener) {
        return new WeChatPayUtil(application, provider, listener);
    }

    private WeChatPayUtil(@NonNull Application application, @NonNull WeChatPayProvider provider, @NonNull WeChatPayListener listener) {
        this.mProvider = provider;
        this.mListenerWeakReference = new WeakReference<WeChatPayListener>(listener);
        this.mApi = WXAPIFactory.createWXAPI((Context)application, null, (boolean)true);
    }

    @NonNull
    public IWXAPI getApi() {
        return this.mApi;
    }

    @CheckResult
    public boolean initiateWeChatPayRedirect(@NonNull WeChatPaySdkRedirectData weChatPaySdkRedirectData) {
        this.mApi.registerApp(weChatPaySdkRedirectData.getAppId());
        return this.mApi.sendReq((BaseReq)this.generatePayRequest(weChatPaySdkRedirectData));
    }

    public void handleIntent(@NonNull Intent intent) {
        this.mApi.handleIntent(intent, (IWXAPIEventHandler)this);
    }

    public void detach() {
        this.mApi.detach();
    }

    public void onReq(@NonNull BaseReq baseReq) {
    }

    public void onResp(@NonNull BaseResp baseResp) {
        WeChatPayListener weChatPayListener = (WeChatPayListener)this.mListenerWeakReference.get();
        if (weChatPayListener == null) {
            throw new RuntimeException("The weak reference to " + WeChatPayListener.class.getName() + " is null");
        }
        WeChatPayDetails weChatPayDetails = new WeChatPayDetails.Builder(String.valueOf(baseResp.errCode)).build();
        weChatPayListener.onPaymentDetails(baseResp, weChatPayDetails);
    }

    @NonNull
    private PayReq generatePayRequest(@NonNull WeChatPaySdkRedirectData weChatPaySdkRedirectData) {
        PayReq request = new PayReq();
        request.appId = weChatPaySdkRedirectData.getAppId();
        request.partnerId = weChatPaySdkRedirectData.getPartnerId();
        request.prepayId = weChatPaySdkRedirectData.getPrepayId();
        request.packageValue = weChatPaySdkRedirectData.getPackageValue();
        request.nonceStr = weChatPaySdkRedirectData.getNonceStr();
        request.timeStamp = weChatPaySdkRedirectData.getTimestamp();
        request.sign = weChatPaySdkRedirectData.getSignature();
        request.options = new PayReq.Options();
        request.options.callbackClassName = this.mProvider.getCallbackActivityName();
        return request;
    }
}

