/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.customization;

import com.adyen.threeds2.customization.ButtonCustomization;
import com.adyen.threeds2.customization.Customization;
import com.adyen.threeds2.customization.ExpandableInfoCustomization;
import com.adyen.threeds2.customization.LabelCustomization;
import com.adyen.threeds2.customization.ScreenCustomization;
import com.adyen.threeds2.customization.SelectionItemCustomization;
import com.adyen.threeds2.customization.TextBoxCustomization;
import com.adyen.threeds2.customization.ToolbarCustomization;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.util.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UiCustomization {
    private final Map<ButtonType, ButtonCustomization> a = new HashMap<ButtonType, ButtonCustomization>();
    private final Map<Class<? extends Customization>, Customization> b = new HashMap<Class<? extends Customization>, Customization>();

    public ButtonCustomization getButtonCustomization(ButtonType buttonType) throws InvalidInputException {
        Preconditions.requireNonNull("buttonType", (Object)buttonType);
        return this.a(buttonType);
    }

    public void setButtonCustomization(ButtonCustomization buttonCustomization, ButtonType buttonType) throws InvalidInputException {
        Preconditions.requireNonNull("buttonType", (Object)buttonType);
        this.a.put(buttonType, buttonCustomization);
    }

    public ScreenCustomization getScreenCustomization() {
        return this.a(ScreenCustomization.class);
    }

    public void setScreenCustomization(ScreenCustomization screenCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("screenCustomization", screenCustomization);
        this.b.put(ScreenCustomization.class, screenCustomization);
    }

    public ToolbarCustomization getToolbarCustomization() {
        return this.a(ToolbarCustomization.class);
    }

    public void setToolbarCustomization(ToolbarCustomization toolbarCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("toolbarCustomization", toolbarCustomization);
        this.b.put(ToolbarCustomization.class, toolbarCustomization);
    }

    public LabelCustomization getLabelCustomization() {
        return this.a(LabelCustomization.class);
    }

    public void setLabelCustomization(LabelCustomization labelCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("labelCustomization", labelCustomization);
        this.b.put(LabelCustomization.class, labelCustomization);
    }

    public TextBoxCustomization getTextBoxCustomization() {
        return this.a(TextBoxCustomization.class);
    }

    public void setTextBoxCustomization(TextBoxCustomization textBoxCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("textBoxCustomization", textBoxCustomization);
        this.b.put(TextBoxCustomization.class, textBoxCustomization);
    }

    public SelectionItemCustomization getSelectionItemCustomization() {
        return this.a(SelectionItemCustomization.class);
    }

    public void setSelectionItemCustomization(SelectionItemCustomization selectionItemCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("selectionItemCustomization", selectionItemCustomization);
        this.b.put(SelectionItemCustomization.class, selectionItemCustomization);
    }

    public ExpandableInfoCustomization getExpandableInfoCustomization() {
        return this.a(ExpandableInfoCustomization.class);
    }

    public void setExpandableInfoCustomization(ExpandableInfoCustomization expandableInfoCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("expandableInfoCustomization", expandableInfoCustomization);
        this.b.put(ExpandableInfoCustomization.class, expandableInfoCustomization);
    }

    public void setToolbarTitle(String title) {
        Preconditions.requireNonEmpty("title", title);
        ToolbarCustomization toolbarCustomization = this.a(ToolbarCustomization.class);
        toolbarCustomization.setHeaderText(title);
    }

    public void setStatusBarColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ScreenCustomization screenCustomization = this.a(ScreenCustomization.class);
        screenCustomization.setStatusBarColor(hexColorCode);
    }

    public void setScreenBackgroundColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ScreenCustomization screenCustomization = this.a(ScreenCustomization.class);
        screenCustomization.setBackgroundColor(hexColorCode);
    }

    public void setTextColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ScreenCustomization screenCustomization = this.a(ScreenCustomization.class);
        screenCustomization.setTextColor(hexColorCode);
        ToolbarCustomization toolbarCustomization = this.a(ToolbarCustomization.class);
        toolbarCustomization.setTextColor(hexColorCode);
        ButtonCustomization buttonCustomization = this.a(ButtonType.CANCEL);
        buttonCustomization.setTextColor(hexColorCode);
        LabelCustomization labelCustomization = this.a(LabelCustomization.class);
        labelCustomization.setTextColor(hexColorCode);
        labelCustomization.setHeadingTextColor(hexColorCode);
        labelCustomization.setInputLabelTextColor(hexColorCode);
        TextBoxCustomization textBoxCustomization = this.a(TextBoxCustomization.class);
        textBoxCustomization.setTextColor(hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.a(SelectionItemCustomization.class);
        selectionItemCustomization.setTextColor(hexColorCode);
        ExpandableInfoCustomization expandableInfoCustomization = this.a(ExpandableInfoCustomization.class);
        expandableInfoCustomization.setTextColor(hexColorCode);
        expandableInfoCustomization.setHeadingTextColor(hexColorCode);
        expandableInfoCustomization.setExpandStateIndicatorColor(hexColorCode);
    }

    public void setBorderColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        TextBoxCustomization textBoxCustomization = this.a(TextBoxCustomization.class);
        textBoxCustomization.setBorderColor(hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.a(SelectionItemCustomization.class);
        selectionItemCustomization.setBorderColor(hexColorCode);
        ExpandableInfoCustomization expandableInfoCustomization = this.a(ExpandableInfoCustomization.class);
        expandableInfoCustomization.setBorderColor(hexColorCode);
    }

    public void setTintColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ToolbarCustomization toolbarCustomization = this.a(ToolbarCustomization.class);
        toolbarCustomization.setBackgroundColor(hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.a(SelectionItemCustomization.class);
        selectionItemCustomization.setSelectionIndicatorTintColor(hexColorCode);
        block4: for (ButtonType buttonType : ButtonType.values()) {
            ButtonCustomization buttonCustomization = this.a(buttonType);
            switch (buttonType) {
                case CANCEL: {
                    continue block4;
                }
                case RESEND: {
                    buttonCustomization.setTextColor(hexColorCode);
                    continue block4;
                }
                default: {
                    buttonCustomization.setBackgroundColor(hexColorCode);
                }
            }
        }
    }

    public void setHighlightedBackgroundColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.a(SelectionItemCustomization.class);
        selectionItemCustomization.setHighlightedBackgroundColor(hexColorCode);
        ExpandableInfoCustomization expandableInfoCustomization = this.a(ExpandableInfoCustomization.class);
        expandableInfoCustomization.setHighlightedBackgroundColor(hexColorCode);
        List<ButtonType> list = Arrays.asList(ButtonType.CANCEL, ButtonType.RESEND);
        for (ButtonType buttonType : list) {
            ButtonCustomization buttonCustomization = this.a(buttonType);
            buttonCustomization.setBackgroundColor(hexColorCode);
        }
    }

    private ButtonCustomization a(ButtonType buttonType) {
        ButtonCustomization buttonCustomization = this.a.get((Object)buttonType);
        if (buttonCustomization == null) {
            buttonCustomization = new ButtonCustomization();
            this.a.put(buttonType, buttonCustomization);
        }
        return buttonCustomization;
    }

    private <T extends Customization> T a(Class<T> clazz) {
        Customization customization = this.b.get(clazz);
        if (customization == null) {
            try {
                Customization customization2 = (Customization)clazz.newInstance();
                this.b.put(clazz, customization2);
                return (T)customization2;
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("Could not instantiate " + clazz.getSimpleName(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Could not access constructor of " + clazz.getSimpleName(), illegalAccessException);
            }
        }
        return (T)customization;
    }

    public static enum ButtonType {
        VERIFY,
        CONTINUE,
        NEXT,
        CANCEL,
        RESEND;

    }
}

