/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.util;

import com.adyen.threeds2.exception.InvalidInputException;

public final class Preconditions {
    public static void requireNonNull(String name, Object object) throws InvalidInputException {
        if (object == null) {
            throw new InvalidInputException(name + " must not be null.", null);
        }
    }

    public static void requireNonEmpty(String name, String value) throws InvalidInputException {
        if (value == null || value.length() == 0) {
            throw new InvalidInputException(name + " must not be empty.", null);
        }
    }

    public static void requireNonNegative(String name, int value) throws InvalidInputException {
        if (value < 0) {
            throw new InvalidInputException(name + " must not be negative.", null);
        }
    }

    public static void requireNonLessThan(String name, int value, int threshold) throws InvalidInputException {
        if (value < threshold) {
            throw new InvalidInputException(name + " must not be less than " + threshold + ".", null);
        }
    }

    private Preconditions() {
    }
}

