/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.customization;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.graphics.Typeface;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.util.Preconditions;

public class Customization {
    private String a;
    private String b;
    private int c = -1;

    public static Integer parseHexColorCode(String hexColorCode) {
        if (hexColorCode != null && !hexColorCode.isEmpty() && hexColorCode.charAt(0) == '#') {
            try {
                return Color.parseColor((String)hexColorCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Typeface parseTypeface(Context context, String fontName) {
        if (fontName == null) {
            return null;
        }
        Typeface typeface = null;
        try {
            typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeface != null) {
            return typeface;
        }
        try {
            typeface = Typeface.createFromFile((String)fontName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeface != null) {
            return typeface;
        }
        try {
            typeface = Typeface.create((String)fontName, (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeface != null) {
            return typeface;
        }
        return null;
    }

    Customization() {
    }

    public String getTextColor() {
        return this.a;
    }

    public void setTextColor(String hexColorCode) throws InvalidInputException {
        this.a = this.a(hexColorCode);
    }

    public String getTextFontName() {
        return this.b;
    }

    public void setTextFontName(String fontName) throws InvalidInputException {
        this.b = this.a("fontName", fontName);
    }

    public int getTextFontSize() {
        return this.c;
    }

    public void setTextFontSize(int fontSize) throws InvalidInputException {
        this.c = this.a("fontSize", fontSize);
    }

    Integer a(String string, int n2) throws InvalidInputException {
        Preconditions.requireNonNegative(string, n2);
        return n2;
    }

    String a(String string, String string2) throws InvalidInputException {
        Preconditions.requireNonEmpty(string, string2);
        return string2;
    }

    String a(String string) throws InvalidInputException {
        Integer n2 = Customization.parseHexColorCode(string);
        Preconditions.requireNonNull("hexColorCode", n2);
        return string;
    }
}

