/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2.exception;

/**
 * This exception is thrown if an internal error is encountered by the 3DS SDK.
 * <p>
 * Created by Ran Haveshush on 24/08/2018.
 */
public final class SDKRuntimeException extends RuntimeException {
    private static final long serialVersionUID = 3282225212522028461L;

    private final String mErrorCode;

    public SDKRuntimeException(final String message, final String errorCode, final Throwable cause) {
        super(message, cause);

        mErrorCode = errorCode;
    }

    public String getErrorCode() {
        return mErrorCode;
    }
}
