/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.util;

import android.text.TextUtils;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.parameters.ConfigParameters;
import com.adyen.threeds2.util.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public final class AdyenConfigParameters {
    public static final a DIRECTORY_SERVER_ID = new a("threeds2.directoryServer", "id");
    public static final a DIRECTORY_SERVER_PUBLIC_KEY = new a("threeds2.directoryServer", "publicKey");
    public static final a DIRECTORY_SERVER_ROOT_CERTIFICATES = new a("threeds2.directoryServer", "rootCertificates");
    public static final a SECURITY_APP_SIGNATURE = new a("security", "appSignature");
    public static final a SECURITY_TRUSTED_APP_STORES = new a("security", "trustedAppStores");
    public static final a SECURITY_MALICIOUS_APPS = new a("security", "maliciousApps");
    public static final a DEVICE_PARAMETER_BLOCK_LIST = new a(null, "deviceParameterBlockList");

    /*
     * WARNING - void declaration
     */
    public static Collection<String> getParamValues(ConfigParameters configParameters, a parameter) throws InvalidInputException {
        void var1_1;
        String string = AdyenConfigParameters.getParamValue(configParameters, (a)var1_1);
        if (string == null) {
            return null;
        }
        return Arrays.asList(string.split(";"));
    }

    /*
     * WARNING - void declaration
     */
    public static String getParamValue(ConfigParameters configParameters, a parameter) throws InvalidInputException {
        String string;
        void var1_1;
        void v02 = var1_1;
        Preconditions.requireNonNull("configParameters", string);
        Preconditions.requireNonNull("parameter", var1_1);
        string = v02.a();
        return configParameters.getParamValue(string, v02.b());
    }

    /*
     * WARNING - void declaration
     */
    static void a(ConfigParameters configParameters, a parameter, Collection<String> paramValues) throws InvalidInputException {
        void var1_1;
        void var2_2;
        Preconditions.requireNonNull("paramValues", var2_2);
        AdyenConfigParameters.a(configParameters, (a)var1_1, TextUtils.join((CharSequence)";", (Iterable)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static void a(ConfigParameters configParameters, a parameter, String paramValue) throws InvalidInputException {
        void var2_2;
        String string;
        void var1_1;
        void v02 = var1_1;
        Preconditions.requireNonNull("configParameters", string);
        Preconditions.requireNonNull("parameter", var1_1);
        Preconditions.requireNonEmpty("paramValue", (String)var2_2);
        string = v02.a();
        configParameters.addParam(string, v02.b(), (String)var2_2);
    }

    private AdyenConfigParameters() {
        throw new IllegalStateException("No instances.");
    }

    private static final class a {
        private final String a;
        private final String b;

        /*
         * WARNING - void declaration
         */
        a(String group, String paramName) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        String a() {
            return this.a;
        }

        String b() {
            return this.b;
        }
    }

    public static final class Builder {
        private final String a;
        private final String b;
        private final String c;
        private String d;
        private Set<String> e;
        private Set<String> f;
        private Set<String> g;

        /*
         * WARNING - void declaration
         */
        public Builder(String directoryServerId, String directoryServerPublicKey, String directoryServerRootCertificates) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public Builder appSignature(String appSignature) {
            void var1_1;
            this.d = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder trustedAppStores(Set<String> trustedAppStores) {
            void var1_1;
            this.e = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder maliciousApps(Set<String> maliciousApps) {
            void var1_1;
            this.f = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder deviceParameterBlockList(Set<String> deviceParameterBlockList) {
            void var1_1;
            this.g = var1_1;
            return this;
        }

        public ConfigParameters build() throws InvalidInputException {
            ConfigParameters configParameters;
            Builder builder = this;
            Preconditions.requireNonEmpty("directoryServerId", builder.a);
            Preconditions.requireNonEmpty("directoryServerPublicKey", builder.b);
            ConfigParameters configParameters2 = configParameters;
            configParameters2();
            Set<String> set = DIRECTORY_SERVER_ID;
            AdyenConfigParameters.a(configParameters2, (a)((Object)set), ((Builder)this).a);
            set = DIRECTORY_SERVER_PUBLIC_KEY;
            AdyenConfigParameters.a(configParameters, (a)((Object)set), ((Builder)this).b);
            set = builder.c;
            if (set != null) {
                AdyenConfigParameters.a(configParameters2, DIRECTORY_SERVER_ROOT_CERTIFICATES, (String)((Object)set));
            }
            if ((set = ((Builder)this).d) != null) {
                AdyenConfigParameters.a(configParameters2, SECURITY_APP_SIGNATURE, (String)((Object)set));
            }
            if ((set = ((Builder)this).e) != null) {
                AdyenConfigParameters.a(configParameters2, SECURITY_TRUSTED_APP_STORES, set);
            }
            if ((set = ((Builder)this).f) != null) {
                AdyenConfigParameters.a(configParameters2, SECURITY_MALICIOUS_APPS, set);
            }
            if ((this = ((Builder)this).g) != null) {
                AdyenConfigParameters.a(configParameters2, DEVICE_PARAMETER_BLOCK_LIST, (Collection<String>)this);
            }
            return configParameters2;
        }
    }
}

