/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2;

/**
 * This interface represents a warning that is produced by the 3DS SDK while performing security checks during
 * the 3DS SDK initialization.
 * <p>
 * Created by Ran Haveshush on 24/08/2018.
 */
public interface Warning {
    /**
     * The {@link Warning} severity.
     */
    enum Severity {
        LOW, MEDIUM, HIGH
    }

    /**
     * @return The {@link Warning} ID.
     */
    String getID();

    /**
     * @return The {@link Warning} message.
     */
    String getMessage();

    /**
     * @return The {@link Severity} that represents the severity level of the {@link Warning}.
     */
    Severity getSeverity();
}
