/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2;

/**
 * An instance of this interface holds transaction data that the App passes to the 3DS Server for creating the {@code AReq}.
 * <p>
 * Created by Ran Haveshush on 24/08/2018.
 */
public interface AuthenticationRequestParameters {
    /**
     * @return A JWE {@link String} that represents the encrypted device data.
     */
    String getDeviceData();

    /**
     * @return An UUID {@link String} that represents the SDK Transaction ID.
     */
    String getSDKTransactionID();

    /**
     * The SDK App ID is unique and is generated during installation and update of the App on the Cardholder’s device.
     *
     * @return An UUID {@link String} that represents then SDK App ID.
     */
    String getSDKAppID();

    /**
     * @return The SDK Reference Number assigned by EMVCo.
     */
    String getSDKReferenceNumber();

    /**
     * @return The public key component of the ephemeral key pair as a String representation of a JWK object.
     */
    String getSDKEphemeralPublicKey();

    /**
     * Returns the protocol version that is used for the transaction.
     * <p>
     * The SDK receives the protocol version as a parameter in the {@link ThreeDS2Service#createTransaction(String, String)}
     * method and determines whether it supports the version. If the SDK does not receive the protocol version as a parameter in the method,
     * then it returns the latest version that it supports.
     *
     * @return The protocol version that is used for the transaction.
     */
    String getMessageVersion();
}
