/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2;

import android.app.Activity;

import com.adyen.threeds2.parameters.ChallengeParameters;

import kotlin.Deprecated;

/**
 * A callback object that implements this interface will receive challenge status notifications from the 3DS SDK.
 * This receiver object may be notified through various methods. Depending on the result of the challenge process, the App may display a message
 * or redirect the Cardholder to a screen in the App.
 * <p>
 * @deprecated Use {@link ChallengeStatusHandler} instead, a simpler interface to notify the app
 * with the necessary challenge status.
 */
@Deprecated(
        message = "Use 'ChallengeStatusHandler' instead."
)
public interface ChallengeStatusReceiver {
    /**
     * This method will be called when the challenge process is completed.<br>
     * When a transaction is completed, the transaction status shall be available.
     *
     * @param completionEvent The {@link CompletionEvent} represents information about the challenge process completion.
     */
    void completed(CompletionEvent completionEvent);

    /**
     * This method will be called when the Cardholder selects the option to cancel the transaction on the challenge screen.<br>
     * The 3DS SDK will end the challenge flow before sending notification about the cancelled event to the App.
     * <p>
     * Notice: The App should invoke the {@link Transaction#close()} method to close the {@link Transaction} object properly,<br>
     * and display subsequent screens after it receives notification about the cancelled event.
     */
    void cancelled();

    /**
     * This method will be called when the challenge process reaches or exceeds the timeout specified in the call for
     * {@link Transaction#doChallenge(Activity, ChallengeParameters, ChallengeStatusReceiver, int)}.<br>
     * The SDK will stop and end the challenge flow as soon as possible before sending notification about the timed out
     * event to the App.
     * <p>
     * Notice: The App should invoke the {@link Transaction#close()} method to close the {@link Transaction} object properly,<br>
     * and display subsequent screens after it receives notification about the cancelled event.
     */
    void timedout();

    /**
     * This method will be called when the 3DS SDK receives an error message form the ACS.<br>
     * The 3DS SDK sends the error code and details from this error message as part of the notification to the App.<br>
     * The 3DS SDK will end the challenge flow before sending notification about the Protocol Error event to the App.
     * <p>
     * In the 3DS SDK context, a protocol error is any error message that is returned by the ACS.
     * <p>
     * Notice: The App should invoke the {@link Transaction#close()} method to close the {@link Transaction} object properly,<br>
     * and display subsequent screens after it receives notification about the cancelled event.
     *
     * @param protocolErrorEvent The {@link ProtocolErrorEvent} contains the protocol error code and details.
     */
    void protocolError(ProtocolErrorEvent protocolErrorEvent);

    /**
     * This method will be called when the 3DS SDK encounters errors during the challenge process.<br>
     * The 3DS SDK will end the challenge flow before sending notification about the Runtime Error event to the App.
     * <p>
     * In the 3DS SDK context, a runtime error is any error encounter during the challenge process.
     * <p>
     * Notice: The App should invoke the {@link Transaction#close()} method to close the {@link Transaction} object properly,<br>
     * and display subsequent screens after it receives notification about the cancelled event.
     *
     * @param runtimeErrorEvent The {@link RuntimeErrorEvent} contains the runtime error code and details.
     */
    void runtimeError(RuntimeErrorEvent runtimeErrorEvent);
}
