/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2;

/**
 * This interface represents a protocol error that is generated by the 3DS SDK to be returned to the ACS.<br>
 * The 3DS SDK sends the error code and details from this error message as part of the notification to the App.
 * <p>
 * Created by Ran Haveshush on 24/08/2018.
 */
public interface ProtocolErrorEvent {
    /**
     * @return The {@link Transaction} ID.
     */
    String getSDKTransactionID();

    /**
     * @return The {@link ErrorMessage} containing the protocol error.
     */
    ErrorMessage getErrorMessage();


    /**
     * @return The {@link String} containing details required for Adyen to identify the final status
     * of the transaction.
     */
    String getAdditionalDetails();
}
