package com.adyen.threeds2.result

import io.michaelrocks.paranoid.Obfuscate

@Obfuscate
enum class MessageField(val identifier: String) {
    NONE("Non Applicable"),

    MESSAGE_TYPE("messageType"),
    MESSAGE_VERSION("messageVersion"),

    ACS_TRANSACTION_ID("acsTransID"),
    THREEDS_SERVER_TRANSACTION_ID("threeDSServerTransID"),
    SDK_TRANSACTION_ID("sdkTransID"),
    THREEDS_REQUESTOR_APP_URL("threeDSRequestorAppURL"),

    SDK_COUNTER_A_TO_S("sdkCounterStoA"),
    ACS_COUNTER_A_TO_S("acsCounterAtoS"),
    ACS_UI_TYPE("acsUiType"),
    TRANSACTION_STATUS("transStatus"),
    CHALLENGE_COMPLETION_INDICATOR("challengeCompletionInd"),

    ACS_HTML("acsHTML"),
    ACS_HTML_REFRESH("acsHTMLRefresh"),

    CHALLENGE_INFO_HEADER("challengeInfoHeader"),
    CHALLENGE_INFO_TEXT("challengeInfoText"),
    CHALLENGE_INFO_LABEL("challengeInfoLabel"),
    CHALLENGE_INFO_TEXT_INDICATOR("challengeInfoTextIndicator"),
    RESEND_INFO_LABEL("resendInformationLabel"),
    WHY_INFO_LABEL("whyInfoLabel"),
    WHY_INFO_TEXT("whyInfoText"),
    EXPAND_INFO_LABEL("expandInfoLabel"),
    EXPAND_INFO_TEXT("expandInfoText"),
    ISSUER_IMAGE("issuerImage"),
    ISSUER_IMAGE_MEDIUM("medium"),
    ISSUER_IMAGE_HIGH("high"),
    ISSUER_IMAGE_EXTRA_HIGH("extraHigh"),
    PS_IMAGE("psImage"),
    WHITELISTING_INFO_TEXT("whitelistingInfoText"),
    WHITELISTING_DATA_ENTRY("whitelistingDataEntry"),

    SUBMIT_AUTHENTICATION_LABEL("submitAuthenticationLabel"),

    CHALLENGE_ADD_INFO("challengeAddInfo"),
    OOB_CONTINUE_LABEL("oobContinueLabel"),
    OOP_APP_LABEL("oobAppLabel"),
    OOB_APP_URL("oobAppURL"),
    CHALLENGE_SELECT_INFO("challengeSelectInfo"),

    MESSAGE_EXTENSION("messageExtension"),
    MESSAGE_EXTENSION_NAME("name"),
    MESSAGE_EXTENSION_ID("id"),
    MESSAGE_EXTENSION_CRITICALITY_INDICATOR("criticalityIndicator"),
    MESSAGE_EXTENSION_DATA("data"),
    MESSAGE_EXTENSION_VERSION("version"),
    MESSAGE_EXTENSION_CHALLENGE_DATA("challengeData"),

    ERROR_CODE("errorCode"),
    ERROR_COMPONENT("errorComponent"),
    ERROR_DESCRIPTION("errorDescription"),
    ERROR_DETAIL("errorDetail"),
    ERROR_MESSAGE_TYPE("errorMessageType"),
}
