package com.adyen.threeds2.result.models

import com.adyen.threeds2.internal.util.DestroyableString

internal class TransactionIdentifiers(
    sdkTransactionId: String? = null,
    serverTransactionId: String? = null,
    acsTransactionId: String? = null,
    acsReferenceNumber: String? = null,
) {

    private val _sdkTransactionId = sdkTransactionId?.let { DestroyableString(it) }
    val sdkTransactionId
        get() = _sdkTransactionId?.value

    private val _serverTransactionId = serverTransactionId?.let { DestroyableString(it) }
    val serverTransactionId
        get() = _serverTransactionId?.value

    private val _acsTransactionId = acsTransactionId?.let { DestroyableString(it) }
    val acsTransactionId
        get() = _acsTransactionId?.value

    private val _acsReferenceNumber = acsReferenceNumber?.let { DestroyableString(it) }
    val acsReferenceNumber
        get() = _acsReferenceNumber?.value

    fun destroy() {
        _sdkTransactionId?.destroy()
        _serverTransactionId?.destroy()
        _acsTransactionId?.destroy()
        _acsReferenceNumber?.destroy()
    }
}

