/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2;

/**
 * This interface represents an error message that is returned by the ACS to the 3DS SDK
 * or an error message that is generated by the 3DS SDK to be returned to the ACS.
 * <p>
 * Created by Ran Haveshush on 24/08/2018.
 */
public interface ErrorMessage {
    /**
     * @return The {@link Transaction} ID.
     */
    String getTransactionID();

    /**
     * @return The error code.
     */
    String getErrorCode();

    /**
     * @return The error description.
     */
    String getErrorDescription();

    /**
     * @return The error details.
     */
    String getErrorDetails();
}
