/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2.customization;

import android.app.Activity;

import com.adyen.threeds2.exception.InvalidInputException;

/**
 * This class provides methods for the App to pass screen customization parameters to the 3DS SDK.
 * <p>
 * Created by Ran Haveshush on 04/10/2018.
 */
public final class ScreenCustomization extends Customization {

    private String mStatusBarColorCode;

    private String mBackgroundColorCode;

    /**
     * @return The color code of the status bar.
     */
    public String getStatusBarColor() {
        return mStatusBarColorCode;
    }

    /**
     * Sets the color of the statue bar.
     *
     * @param hexColorCode The color code in Hex format. For example "#999999".
     * @throws InvalidInputException This exception shall be thrown if an input parameter is invalid.
     */
    public void setStatusBarColor(final String hexColorCode) {
        mStatusBarColorCode = requireHexColorCode(hexColorCode);
    }

    /**
     * @return The color code of the challenge {@link Activity}'s background.
     */
    public String getBackgroundColor() {
        return mBackgroundColorCode;
    }

    /**
     * Sets the background color of the challenge {@link Activity}.
     *
     * @param hexColorCode The colour code in Hex format. For example "#999999".
     * @throws InvalidInputException This exception shall be thrown if an input parameter is invalid.
     */
    public void setBackgroundColor(final String hexColorCode) throws InvalidInputException {
        mBackgroundColorCode = requireHexColorCode(hexColorCode);
    }
}
