/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2.exception;

/**
 * This class represents a runtime exception that occurs due to one of the following reasons:
 * <ul>
 * <li>Parameter value is mandatory, but was not provided.
 * <li>Parameter value does not conform to the specified format.
 * <li>Parameter value exceeds the maximum limit.
 * <li>Parameter value does not meet the minimum length criteria.
 * </ul>
 * <p>
 * Created by Ran Haveshush on 24/08/2018.
 */
public final class InvalidInputException extends RuntimeException {
    private static final long serialVersionUID = 3724437594571046013L;

    public InvalidInputException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
