/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2.exception;

import android.content.Context;

import com.adyen.threeds2.ThreeDS2Service;
import com.adyen.threeds2.customization.UiCustomization;
import com.adyen.threeds2.parameters.ConfigParameters;

/**
 * This class represents an exception that is thrown if the 3DS SDK has not been initialized.<br>
 * The 3DS SDK is initialized by calling {@link ThreeDS2Service#initialize(Context, ConfigParameters, String, UiCustomization)}.
 * <p>
 * Created by Ran Haveshush on 24/08/2018.
 */
public final class SDKNotInitializedException extends Exception {
    private static final long serialVersionUID = -7377646942034228985L;

    public SDKNotInitializedException() {
        super(null, null);
    }
}
