package com.adyen.threeds2.result

enum class ResultCode(val code: String) {
    // Common codes to both platforms 1XXX
    USER_CANCEL(
        code = "1001",
        // description = "User cancelled the challenge.",
    ),
    TIMEOUT(
        code = "1002",
        // description = "Challenge has timed out.",
    ),
    MESSAGE_EXTENSION_IS_CRITICAL(
        code = "1003",
        // description = "Message extension with criticalityIndicator true is not supported.",
    ),
    INVALID_MESSAGE_TYPE(
        code = "1004",
        // description = "Message type is invalid and not recognized.",
    ),
    PARSE_MESSAGE_CONTENT_NOT_ENCRYPTED(
        code = "1005",
        // description = "CRes is in plain text instead of encrypted.",
    ),
    POST_ERROR_ESTABLISHING_CONNECTION(
        code = "1006",
        // description = "Error while establishing connection with ACS.",
    ),
    POST_MESSAGE_RESPONSE_TIMEOUT(
        code = "1007",
        // description = "Response to CReq timed out.",
    ),
    MISMATCHING_SDK_TRANSACTION_ID(
        code = "1008",
        // description = "CRes's sdkTransId doesn't match CReq's.",
    ),
    MISMATCHING_THREEDS_SERVER_TRANSACTION_ID(
        code = "1009",
        // description = "CRes's threeDSServerTransId doesn't match CReq's.",
    ),
    MISMATCHING_ACS_TRANSACTION_ID(
        code = "1010",
        // description = "CRes's acsTransId doesn't match CReq's.",
    ),
    MISMATCHING_MESSAGE_VERSION(
        code = "1011",
        // description = "CRes's messageVersion doesn't match CReq's.",
    ),
    MISMATCHING_COUNTERS(
        code = "1012",
        // description = "CRes's acsCounterAtoS doesn't match CReq's sdkCounterStoA.",
    ),
    MESSAGE_FIELD_MISSING_REQUIRED(
        code = "1013",
        // description = "Missing mandatory field.",
    ),
    MESSAGE_FIELD_EMPTY(
        code = "1014",
        // description = "Empty or Null field value.",
    ),

    // Codes specific to Android 2XXX
    // Codes specific to Message Field 21XX
    MESSAGE_FIELD_INVALID_FORMAT(
        code = "2101",
        // description = "Invalid format for field value.",
    ),
    MESSAGE_FIELD_NOT_BASE64URL_ENCODED(
        code = "2102",
        // description = "Field not base64Url encoded",
    ),
    MESSAGE_ISSUER_IMAGE_NO_DENSITY_PRESENT(
        code = "2103",
        // description = "Issuer image isn't present/or valid in any of the densities.",
    ),
    MESSAGE_FIELD_TOO_LONG(
        code = "2104",
        // description = "Field exceeds the maximum length of characters",
    ),
    EMPTY_MESSAGE(
        code = "2105",
        // description = "CRes is empty.",
    ),
    INVALID_TRANSACTION_STATUS(
        code = "2106",
        // description = "Transaction status is invalid and not recognized.",
    ),
    TOO_MANY_MESSAGE_EXTENSIONS(
        code = "2107",
        // description = "CRes exceeds maximum allowed value of message extension.",
    ),
    INVALID_CHALLENGE_TYPE(
        code = "2108",
        // description = "Invalid value sent for challenge type (outside of range)",
    ),

    // Codes specific to Message Parsing 22XX
    PARSE_MESSAGE_DECRYPTION_FAILURE(
        code = "2201",
        // description = "Failure decrypting CRes.",
    ),
    PARSE_MESSAGE_INVALID_JSON(
        code = "2202",
        // description = "CRes is not a valid Json.",
    ),
    PARSE_MESSAGE_CONTENT_TYPE_MISSING(
        code = "2203",
        // description = "CRes header doesn't indicate the content type.",
    ),

    // Codes specific to Cryptography 23XX
    JWE_AUTHENTICATION_TAG_NOT_BASE64URL_ENCODED(
        code = "2301",
        // description = "Authentication tag not base64Url encoded.",
    ),
    JWE_KEY_NOT_BASE64URL_ENCODED(
        code = "2302",
        // description = "JWE key not base64Url encoded.",
    ),
    JWE_PAYLOAD_NOT_BASE64URL_ENCODED(
        code = "2303",
        // description = "JWE payload not base64Url encoded.",
    ),
    JWE_HEADER_NOT_BASE64URL_ENCODED(
        code = "2304",
        // description = "JWE header not base64Url encoded.",
    ),
    JWE_INITIALIZATION_VECTOR_NOT_BASE64URL_ENCODED(
        code = "2305",
        // description = "Initialization vector not base64Url encoded.",
    ),
    JWS_HEADER_NOT_BASE64URL_ENCODED(
        code = "2306",
        // description = "JWS header not base64Url encoded.",
    ),
    JWS_PAYLOAD_NOT_BASE64URL_ENCODED(
        code = "2307",
        // description = "JWS payload not base64Url encoded.",
    ),
    JWS_SIGNATURE_NOT_BASE64URL_ENCODED(
        code = "2308",
        // description = "JWS signature not base64Url encoded.",
    ),

    // Codes specific to ACS Errors 4XXX (XXX = EMVCo Code)
    ERROR_MESSAGE_FROM_ACS_OTHER(
        code = "4001",
        // description = "ACS returned an error code not supported.",
    ),
    ERROR_FROM_ACS_MESSAGE_RECEIVED_INVALID(code = "4101"),
    ERROR_FROM_ACS_MESSAGE_VERSION_NOT_SUPPORTED(code = "4102"),
    ERROR_FROM_ACS_DATA_ELEMENT_MISSING(code = "4201"),
    ERROR_FROM_ACS_MESSAGE_EXTENSION_MISSING(code = "4202"),
    ERROR_FROM_ACS_DATA_ELEMENT_INVALID_FORMAT(code = "4203"),
    ERROR_FROM_ACS_DUPLICATE_DATA_ELEMENT(code = "4204"),
    ERROR_FROM_ACS_TRANSACTION_ID_NOT_RECOGNIZED(code = "4301"),
    ERROR_FROM_ACS_DATA_DECRYPTION_FAILURE(code = "4302"),
    ERROR_FROM_ACS_ACCESS_DENIED(code = "4303"),
    ERROR_FROM_ACS_ISO_CODE_INVALID(code = "4304"),
    ERROR_FROM_ACS_TRANSACTION_DATA_INVALID(code = "4305"),
    ERROR_FROM_ACS_TRANSACTION_TIMED_OUT(code = "4402"),
    ERROR_FROM_ACS_TRANSIENT_SYSTEM_FAILURE(code = "4403"),
    ERROR_FROM_ACS_PERMANENT_SYSTEM_FAILURE(code = "4404"),
    ERROR_FROM_ACS_SYSTEM_CONNECTION_FAILURE(code = "4405"),
}


