package com.adyen.threeds2.result.models

import com.adyen.threeds2.internal.util.DestroyableString

internal class DeviceIdentifiers(
    platform: String,
    platformVersion: String,
    model: String,
) {
    private val _platform = DestroyableString(platform)
    val platform by _platform

    private val _platformVersion = DestroyableString(platformVersion)
    val platformVersion by _platformVersion

    private val _model = DestroyableString(model)
    val model by _model

    fun destroy() {
        _platform.destroy()
        _platformVersion.destroy()
        _model.destroy()
    }
}

