/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2;

/**
 * This interface represents the processing screen that the App may show while communicating with the 3DS server.
 * It will only be shown once, after hidden or if the Activity is recreated the app need to request a new instance to show.
 * <p>
 * Created by Ran Haveshush on 08/10/2018.
 */
public interface ProgressDialog {
    /**
     * Shows the processing screen.
     */
    void show();

    /**
     * Hides the processing screen.
     */
    void hide();
}
