/*
 * Copyright (C) 2018 Adyen N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adyen.threeds2.util;

import com.adyen.threeds2.exception.InvalidInputException;

/**
 * Created by timon on 24/07/2018.
 */
public final class Preconditions {
    public static void requireNonNull(final String name, final Object object) throws InvalidInputException {
        if (object == null) {
            throw new InvalidInputException(name + " must not be null.", null);
        }
    }

    public static void requireNonEmpty(final String name, final String value) throws InvalidInputException {
        if (value == null || value.length() == 0) {
            throw new InvalidInputException(name + " must not be empty.", null);
        }
    }

    public static void requireNonNegative(final String name, final int value) throws InvalidInputException {
        if (value < 0) {
            throw new InvalidInputException(name + " must not be negative.", null);
        }
    }

    public static void requireNonLessThan(final String name, final int value, final int threshold) throws InvalidInputException {
        if (value < threshold) {
            throw new InvalidInputException(name + " must not be less than " + threshold + ".", null);
        }
    }

    private Preconditions() {
        // Empty constructor.
    }
}
