/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.file;

import com.aeontronix.commons.file.builder.FilesBuilder;
import com.aeontronix.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    public static final Pattern defaultPathPattern = FileUtils.compilePathSplitPattern(File.separatorChar);

    public static FilesBuilder buildDir() {
        return new FilesBuilder();
    }

    public static void mkdir(File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (!file.mkdir()) {
            throw new IOException("Unable to create directory: " + file.getPath());
        }
    }

    public static void mkdirs(File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new IOException("Unable to create directory: " + file.getPath());
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            FileUtils.copyDirectory(src, dst);
        } else {
            FileUtils.copyFile(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = new FileOutputStream(dst);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtils.close((Object[])new Object[]{is, os});
            throw throwable;
        }
        IOUtils.close((Object[])new Object[]{is, os});
    }

    public static void copyDirectory(File dir, File destination) throws IOException {
        for (File file : FileUtils.listFileInDir(dir)) {
            File destFile = new File(destination, file.getName());
            if (file.isDirectory()) {
                FileUtils.mkdir(destFile);
                FileUtils.copyDirectory(file, destFile);
                continue;
            }
            FileUtils.copyFile(file, destFile);
        }
    }

    public static byte[] toByteArray(File file) throws IOException {
        byte[] byArray;
        FileInputStream is = new FileInputStream(file);
        try {
            byArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (Throwable throwable) {
            IOUtils.close((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtils.close((Object[])new Object[]{is});
        return byArray;
    }

    public static void checkFileIsDirectory(File ... files) throws IOException {
        for (File file : files) {
            if (!file.exists()) {
                throw new IOException("File " + file.getPath() + " doesn't exist");
            }
            if (file.isDirectory()) continue;
            throw new IOException("File " + file.getPath() + " isn't a directory");
        }
    }

    public static File[] listFileInDir(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Unable to list files in directory: " + directory.getPath());
        }
        return files;
    }

    public static Set<String> listAllFilesNames(File directory, boolean recursive, boolean includeFiles, boolean includeDirs) throws IOException {
        HashSet<String> filepaths = new HashSet<String>();
        FileUtils.recursiveFileNameList(filepaths, directory, null, recursive, includeFiles, includeDirs);
        return filepaths;
    }

    private static void recursiveFileNameList(HashSet<String> filepaths, File file, String path, boolean recursive, boolean includeFiles, boolean includeDirs) throws IOException {
        if (file.isDirectory()) {
            if (path == null || recursive) {
                File[] files = file.listFiles();
                if (files == null) {
                    throw new IOException("Unable to list files in directory: " + file.getPath());
                }
                for (File f : files) {
                    FileUtils.recursiveFileNameList(filepaths, f, path != null ? path + File.separator + f.getName() : f.getName(), recursive, includeFiles, includeDirs);
                }
            }
            if (path != null && includeDirs) {
                filepaths.add(path);
            }
        } else if (includeFiles) {
            filepaths.add(path);
        }
    }

    public static String toString(File file) throws IOException {
        return FileUtils.toString(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file, String encoding) throws IOException {
        String string;
        StringWriter buffer = new StringWriter();
        InputStreamReader fileReader = null;
        try {
            fileReader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            IOUtils.copy((Reader)fileReader, (Writer)buffer);
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            IOUtils.close((Object[])new Object[]{buffer});
            IOUtils.close((Object[])new Object[]{fileReader});
            throw throwable;
        }
        IOUtils.close((Object[])new Object[]{buffer});
        IOUtils.close((Object[])new Object[]{fileReader});
        return string;
    }

    public static void write(File file, String text) throws IOException {
        FileUtils.write(file, text, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String text, String encoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(text.getBytes(encoding));
        }
        catch (Throwable throwable) {
            IOUtils.close((Object[])new Object[]{fos});
            throw throwable;
        }
        IOUtils.close((Object[])new Object[]{fos});
    }

    public static void write(File file, byte[] data) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(data);
        }
        catch (Throwable throwable) {
            IOUtils.close((Object[])new Object[]{fos});
            throw throwable;
        }
        IOUtils.close((Object[])new Object[]{fos});
    }

    public static void delete(File ... file) throws IOException {
        FileUtils.delete(true, file);
    }

    public static void delete(boolean deleteOnExit, File ... files) throws IOException {
        for (File file : files) {
            if (file == null || !file.exists()) continue;
            if (file.isDirectory()) {
                File[] childrens = file.listFiles();
                if (childrens == null) {
                    throw new IOException("Unable to list files in " + file.getPath());
                }
                for (File f : childrens) {
                    FileUtils.delete(deleteOnExit, f);
                }
            }
            if (file.delete()) continue;
            if (deleteOnExit) {
                file.deleteOnExit();
                continue;
            }
            throw new IOException("Unable to delete: " + file.getPath());
        }
    }

    public static SplitPath splitFileNameFromParentPath(String fullPath) {
        return FileUtils.splitFileNameFromParentPath(fullPath, File.separatorChar);
    }

    public static SplitPath splitFileNameFromParentPath(String fullPath, char fileSeparator) {
        Pattern p = fileSeparator == File.separatorChar ? defaultPathPattern : FileUtils.compilePathSplitPattern(fileSeparator);
        Matcher m = p.matcher(fullPath);
        if (!m.find()) {
            throw new IllegalArgumentException("Path pattern cannot be parsed: " + fullPath);
        }
        return new SplitPath(m.group(1), m.group(2));
    }

    public static Pattern compilePathSplitPattern(char fileSeparator) {
        return Pattern.compile("(?:(.*)" + (fileSeparator == '\\' ? "\\\\" : Character.valueOf(fileSeparator)) + ")?(.*)");
    }

    public static String getFileExtension(File file) {
        String fn = file.getName();
        int i = fn.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        return fn.substring(i + 1);
    }

    public static class SplitPath {
        private String parentPath;
        private String filename;

        public SplitPath(@Nullable String parentPath, @NotNull String filename) {
            this.parentPath = parentPath;
            this.filename = filename;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public void setParentPath(String parentPath) {
            this.parentPath = parentPath;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String toString() {
            return "SplitPath{parentPath='" + this.parentPath + '\'' + ", filename='" + this.filename + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SplitPath)) {
                return false;
            }
            SplitPath splitPath = (SplitPath)o;
            if (this.parentPath != null ? !this.parentPath.equals(splitPath.parentPath) : splitPath.parentPath != null) {
                return false;
            }
            return this.filename.equals(splitPath.filename);
        }

        public int hashCode() {
            int result = this.parentPath != null ? this.parentPath.hashCode() : 0;
            result = 31 * result + this.filename.hashCode();
            return result;
        }
    }
}

